/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.facade;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.js.analyze.TopDownAnalyzerFacadeForJS;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.coroutine.CoroutineTransformer;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationResult;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedImportsKt;
import org.jetbrains.kotlin.js.inline.clean.ResolveTemporaryNamesKt;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.ExpandIsCallsKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public final class K2JSTranslator {
    @NotNull
    private final JsConfig config;

    public K2JSTranslator(@NotNull JsConfig config) {
        if (config == null) {
            K2JSTranslator.$$$reportNull$$$0(0);
        }
        this.config = config;
    }

    @NotNull
    public TranslationResult translate(@NotNull List<KtFile> files2, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        if (files2 == null) {
            K2JSTranslator.$$$reportNull$$$0(1);
        }
        if (mainCallParameters == null) {
            K2JSTranslator.$$$reportNull$$$0(2);
        }
        TranslationResult translationResult = this.translate(files2, mainCallParameters, null);
        if (translationResult == null) {
            K2JSTranslator.$$$reportNull$$$0(3);
        }
        return translationResult;
    }

    @NotNull
    public TranslationResult translate(@NotNull List<KtFile> files2, @NotNull MainCallParameters mainCallParameters, @Nullable JsAnalysisResult analysisResult) throws TranslationException {
        if (files2 == null) {
            K2JSTranslator.$$$reportNull$$$0(4);
        }
        if (mainCallParameters == null) {
            K2JSTranslator.$$$reportNull$$$0(5);
        }
        if (analysisResult == null) {
            analysisResult = TopDownAnalyzerFacadeForJS.analyzeFiles(files2, this.config);
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        }
        BindingTrace bindingTrace = analysisResult.getBindingTrace();
        TopDownAnalyzerFacadeForJS.checkForErrors(files2, bindingTrace.getBindingContext());
        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
        Diagnostics diagnostics = bindingTrace.getBindingContext().getDiagnostics();
        TranslationContext context = Translation.generateAst(bindingTrace, files2, mainCallParameters, moduleDescriptor, this.config);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                K2JSTranslator.$$$reportNull$$$0(6);
            }
            return fail;
        }
        JsProgram program = JsInliner.process(context);
        ResolveTemporaryNamesKt.resolveTemporaryNames(program);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                K2JSTranslator.$$$reportNull$$$0(7);
            }
            return fail;
        }
        CoroutineTransformer coroutineTransformer = new CoroutineTransformer(program);
        coroutineTransformer.accept(program);
        RemoveUnusedImportsKt.removeUnusedImports(program);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (DiagnosticUtils.hasError(diagnostics)) {
            TranslationResult.Fail fail = new TranslationResult.Fail(diagnostics);
            if (fail == null) {
                K2JSTranslator.$$$reportNull$$$0(8);
            }
            return fail;
        }
        ExpandIsCallsKt.expandIsCalls(program, context);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ArrayList<String> importedModules = new ArrayList<String>();
        for (StaticContext.ImportedModule module : context.getImportedModules()) {
            importedModules.add(module.getExternalName());
        }
        TranslationResult.Success success = new TranslationResult.Success(this.config, files2, program, diagnostics, importedModules, moduleDescriptor, bindingTrace.getBindingContext());
        if (success == null) {
            K2JSTranslator.$$$reportNull$$$0(9);
        }
        return success;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/facade/K2JSTranslator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/facade/K2JSTranslator";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "translate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "translate";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

