/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public final class ReferenceAccessTranslator
extends AbstractTranslator
implements AccessTranslator {
    @NotNull
    private final JsExpression reference;

    @NotNull
    static ReferenceAccessTranslator newInstance(@NotNull KtSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(1);
        }
        DeclarationDescriptor referenceDescriptor = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression);
        assert (referenceDescriptor != null) : "JetSimpleName expression must reference a descriptor " + expression.getText();
        ReferenceAccessTranslator referenceAccessTranslator = new ReferenceAccessTranslator(referenceDescriptor, context);
        if (referenceAccessTranslator == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(2);
        }
        return referenceAccessTranslator;
    }

    private ReferenceAccessTranslator(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(4);
        }
        super(context);
        this.reference = ReferenceTranslator.translateAsValueReference(descriptor2, this.context());
    }

    @Override
    @NotNull
    public JsExpression translateAsGet() {
        JsExpression jsExpression = this.reference;
        if (jsExpression == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(5);
        }
        return jsExpression;
    }

    @Override
    @NotNull
    public JsExpression translateAsSet(@NotNull JsExpression toSetTo) {
        if (toSetTo == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(6);
        }
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(this.reference, toSetTo);
        if (jsBinaryOperation == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(7);
        }
        return jsBinaryOperation;
    }

    @Override
    @NotNull
    public AccessTranslator getCached() {
        ReferenceAccessTranslator referenceAccessTranslator = this;
        if (referenceAccessTranslator == null) {
            ReferenceAccessTranslator.$$$reportNull$$$0(8);
        }
        return referenceAccessTranslator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/reference/ReferenceAccessTranslator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSetTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/reference/ReferenceAccessTranslator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsGet";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCached";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "translateAsSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

