/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerBuilder;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorForStatements;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.KotlinFrontEndException;
import org.jetbrains.kotlin.util.LookupTrackerUtilKt;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;

public abstract class ExpressionTypingVisitorDispatcher
extends KtVisitor<KotlinTypeInfo, ExpressionTypingContext>
implements ExpressionTypingInternals {
    public static final PerformanceCounter typeInfoPerfCounter = PerformanceCounter.Companion.create("Type info", true);
    private static final Logger LOG = Logger.getInstance(ExpressionTypingVisitor.class);
    private final ExpressionTypingComponents components;
    @NotNull
    private final AnnotationChecker annotationChecker;
    protected final BasicExpressionTypingVisitor basic;
    protected final FunctionsTypingVisitor functions;
    protected final ControlStructureTypingVisitor controlStructures;
    protected final PatternMatchingTypingVisitor patterns;
    protected final DeclarationsCheckerBuilder declarationsCheckerBuilder;

    protected abstract ExpressionTypingVisitorForStatements getStatementVisitor(@NotNull ExpressionTypingContext var1);

    private ExpressionTypingVisitorDispatcher(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker) {
        if (components == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(0);
        }
        if (annotationChecker == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(1);
        }
        this.components = components;
        this.annotationChecker = annotationChecker;
        this.basic = new BasicExpressionTypingVisitor(this);
        this.controlStructures = new ControlStructureTypingVisitor(this);
        this.patterns = new PatternMatchingTypingVisitor(this);
        this.functions = new FunctionsTypingVisitor(this);
        this.declarationsCheckerBuilder = components.declarationsCheckerBuilder;
    }

    @Override
    @NotNull
    public ExpressionTypingComponents getComponents() {
        ExpressionTypingComponents expressionTypingComponents = this.components;
        if (expressionTypingComponents == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(2);
        }
        return expressionTypingComponents;
    }

    @Override
    @NotNull
    public KotlinTypeInfo checkInExpression(@NotNull KtElement callElement, @NotNull KtSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable KtExpression right, @NotNull ExpressionTypingContext context) {
        if (callElement == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(3);
        }
        if (operationSign == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(4);
        }
        if (leftArgument == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(6);
        }
        KotlinTypeInfo kotlinTypeInfo = this.basic.checkInExpression(callElement, operationSign, leftArgument, right, context);
        if (kotlinTypeInfo == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(7);
        }
        return kotlinTypeInfo;
    }

    @Override
    @NotNull
    public final KotlinTypeInfo safeGetTypeInfo(@NotNull KtExpression expression, ExpressionTypingContext context) {
        KotlinTypeInfo typeInfo;
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(8);
        }
        if ((typeInfo = this.getTypeInfo(expression, context)).getType() != null) {
            KotlinTypeInfo kotlinTypeInfo = typeInfo;
            if (kotlinTypeInfo == null) {
                ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(9);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(ErrorUtils.createErrorType("Type for " + expression.getText())).replaceDataFlowInfo(context.dataFlowInfo);
        if (kotlinTypeInfo == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(10);
        }
        return kotlinTypeInfo;
    }

    @Override
    @NotNull
    public final KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(11);
        }
        KotlinTypeInfo result2 = this.getTypeInfo(expression, context, this);
        this.annotationChecker.checkExpression(expression, context.trace);
        KotlinTypeInfo kotlinTypeInfo = result2;
        if (kotlinTypeInfo == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(12);
        }
        return kotlinTypeInfo;
    }

    @Override
    @NotNull
    public final KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression, ExpressionTypingContext context, boolean isStatement) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(13);
        }
        ExpressionTypingContext newContext = context;
        if (CodeFragmentUtilKt.suppressDiagnosticsInDebugMode(expression)) {
            newContext = ExpressionTypingContext.newContext(context, true);
        }
        if (!isStatement) {
            KotlinTypeInfo kotlinTypeInfo = this.getTypeInfo(expression, newContext);
            if (kotlinTypeInfo == null) {
                ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(14);
            }
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.getTypeInfo(expression, newContext, this.getStatementVisitor(newContext));
        if (kotlinTypeInfo == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(15);
        }
        return kotlinTypeInfo;
    }

    protected ExpressionTypingVisitorForStatements createStatementVisitor(ExpressionTypingContext context) {
        return new ExpressionTypingVisitorForStatements(this, ExpressionTypingUtils.newWritableScopeImpl(context, LexicalScopeKind.CODE_BLOCK, this.components.overloadChecker), this.basic, this.controlStructures, this.patterns, this.functions);
    }

    @Override
    public void checkStatementType(@NotNull KtExpression expression, ExpressionTypingContext context) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(16);
        }
        expression.accept(this.createStatementVisitor(context), context);
    }

    @NotNull
    private KotlinTypeInfo getTypeInfo(final @NotNull KtExpression expression, final ExpressionTypingContext context, final KtVisitor<KotlinTypeInfo, ExpressionTypingContext> visitor2) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(17);
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfoPerfCounter.time(new Function0<KotlinTypeInfo>(){

            @Override
            public KotlinTypeInfo invoke() {
                try {
                    KotlinTypeInfo result2;
                    KotlinTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression, context.trace.getBindingContext());
                    if (recordedTypeInfo != null) {
                        return recordedTypeInfo;
                    }
                    context.trace.record(BindingContext.DATA_FLOW_INFO_BEFORE, expression, context.dataFlowInfo);
                    try {
                        result2 = (KotlinTypeInfo)expression.accept(visitor2, context);
                        if (context.trace.get(BindingContext.PROCESSED, expression) == Boolean.TRUE) {
                            KotlinType type2 = context.trace.getBindingContext().getType(expression);
                            return result2.replaceType(type2);
                        }
                        if (result2.getType() instanceof DeferredType) {
                            result2 = result2.replaceType(((DeferredType)result2.getType()).getDelegate());
                        }
                        context.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression, result2);
                    }
                    catch (ReenteringLazyValueComputationException e) {
                        context.trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(expression));
                        result2 = TypeInfoFactoryKt.noTypeInfo(context);
                    }
                    context.trace.record(BindingContext.PROCESSED, expression);
                    BindingContextUtilsKt.recordScope(context.trace, context.scope, expression);
                    BindingContextUtilsKt.recordDataFlowInfo(context.replaceDataFlowInfo(result2.getDataFlowInfo()), expression);
                    try {
                        ExpressionTypingVisitorDispatcher.this.recordTypeInfo(expression, result2);
                    }
                    catch (ReenteringLazyValueComputationException e) {
                        context.trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(expression));
                        return TypeInfoFactoryKt.noTypeInfo(context);
                    }
                    return result2;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (KotlinFrontEndException e) {
                    throw e;
                }
                catch (Throwable e) {
                    context.trace.report(Errors.EXCEPTION_FROM_ANALYZER.on(expression, e));
                    ExpressionTypingVisitorDispatcher.logOrThrowException(expression, e);
                    return TypeInfoFactoryKt.createTypeInfo((KotlinType)ErrorUtils.createErrorType(e.getClass().getSimpleName() + " from analyzer"), context);
                }
            }
        });
        if (kotlinTypeInfo == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(18);
        }
        return kotlinTypeInfo;
    }

    private void recordTypeInfo(@NotNull KtExpression expression, @NotNull KotlinTypeInfo typeInfo) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(19);
        }
        if (typeInfo == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(20);
        }
        LookupTracker lookupTracker = this.getComponents().lookupTracker;
        KotlinType resultType = typeInfo.getType();
        if (resultType != null) {
            LookupTrackerUtilKt.record(lookupTracker, expression, resultType);
        }
    }

    private static void logOrThrowException(@NotNull KtExpression expression, Throwable e) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(21);
        }
        try {
            LOG.error("Exception while analyzing expression at " + DiagnosticUtils.atLocation(expression) + ":\n" + expression.getText() + "\n", e);
        }
        catch (AssertionError errorFromLogger) {
            throw new KotlinFrontEndException(((Throwable)((Object)errorFromLogger)).getMessage(), e);
        }
    }

    @Override
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(22);
        }
        return this.functions.visitLambdaExpression(expression, (ExpressionTypingContext)data.replaceCallPosition(CallPosition.Unknown.INSTANCE));
    }

    @Override
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, ExpressionTypingContext data) {
        if (function2 == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(23);
        }
        return this.functions.visitNamedFunction(function2, data);
    }

    @Override
    public KotlinTypeInfo visitThrowExpression(@NotNull KtThrowExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(24);
        }
        return this.controlStructures.visitThrowExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitReturnExpression(@NotNull KtReturnExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(25);
        }
        return this.controlStructures.visitReturnExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitContinueExpression(@NotNull KtContinueExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(26);
        }
        return this.controlStructures.visitContinueExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitIfExpression(@NotNull KtIfExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(27);
        }
        return this.controlStructures.visitIfExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitTryExpression(@NotNull KtTryExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(28);
        }
        return this.controlStructures.visitTryExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitForExpression(@NotNull KtForExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(29);
        }
        return this.controlStructures.visitForExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitWhileExpression(@NotNull KtWhileExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(30);
        }
        return this.controlStructures.visitWhileExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitDoWhileExpression(@NotNull KtDoWhileExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(31);
        }
        return this.controlStructures.visitDoWhileExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitBreakExpression(@NotNull KtBreakExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(32);
        }
        return this.controlStructures.visitBreakExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitIsExpression(@NotNull KtIsExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(33);
        }
        return this.patterns.visitIsExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(34);
        }
        return this.patterns.visitWhenExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(35);
        }
        return this.basic.visitSimpleNameExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(36);
        }
        return this.basic.visitParenthesizedExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitConstantExpression(@NotNull KtConstantExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(37);
        }
        return this.basic.visitConstantExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(38);
        }
        return this.basic.visitBinaryWithTypeRHSExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitThisExpression(@NotNull KtThisExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(39);
        }
        return this.basic.visitThisExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitSuperExpression(@NotNull KtSuperExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(40);
        }
        return this.basic.visitSuperExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(41);
        }
        return this.basic.visitBlockExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(42);
        }
        return this.basic.visitClassLiteralExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(43);
        }
        return this.basic.visitCallableReferenceExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(44);
        }
        return this.basic.visitObjectLiteralExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitQualifiedExpression(@NotNull KtQualifiedExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(45);
        }
        return this.basic.visitQualifiedExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitCallExpression(@NotNull KtCallExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(46);
        }
        return this.basic.visitCallExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitUnaryExpression(@NotNull KtUnaryExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(47);
        }
        return this.basic.visitUnaryExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(48);
        }
        return this.basic.visitLabeledExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(49);
        }
        return this.basic.visitBinaryExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(50);
        }
        return this.basic.visitArrayAccessExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext data) {
        if (dcl == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(51);
        }
        return this.basic.visitDeclaration(dcl, data);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass2, ExpressionTypingContext data) {
        if (klass2 == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(52);
        }
        return this.basic.visitClass(klass2, data);
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property, ExpressionTypingContext data) {
        if (property == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(53);
        }
        return this.basic.visitProperty(property, data);
    }

    @Override
    public KotlinTypeInfo visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(54);
        }
        return this.basic.visitStringTemplateExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression, ExpressionTypingContext data) {
        if (expression == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(55);
        }
        return this.basic.visitAnnotatedExpression(expression, data);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element, ExpressionTypingContext data) {
        if (element == null) {
            ExpressionTypingVisitorDispatcher.$$$reportNull$$$0(56);
        }
        return element.accept(this.basic, data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationChecker";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationSign";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftArgument";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dcl";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "safeGetTypeInfo";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkInExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "safeGetTypeInfo";
                break;
            }
            case 11: 
            case 13: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkStatementType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "recordTypeInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "logOrThrowException";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitIsExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitQualifiedExpression";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitUnaryExpression";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclaration";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitKtElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ForBlock
    extends ExpressionTypingVisitorDispatcher {
        private final ExpressionTypingVisitorForStatements visitorForBlock;

        public ForBlock(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker, @NotNull LexicalWritableScope writableScope) {
            if (components == null) {
                ForBlock.$$$reportNull$$$0(0);
            }
            if (annotationChecker == null) {
                ForBlock.$$$reportNull$$$0(1);
            }
            if (writableScope == null) {
                ForBlock.$$$reportNull$$$0(2);
            }
            super(components, annotationChecker);
            this.visitorForBlock = new ExpressionTypingVisitorForStatements(this, writableScope, this.basic, this.controlStructures, this.patterns, this.functions);
        }

        @Override
        protected ExpressionTypingVisitorForStatements getStatementVisitor(@NotNull ExpressionTypingContext context) {
            if (context == null) {
                ForBlock.$$$reportNull$$$0(3);
            }
            return this.visitorForBlock;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationChecker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writableScope";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStatementVisitor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ForDeclarations
    extends ExpressionTypingVisitorDispatcher {
        public ForDeclarations(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker) {
            if (components == null) {
                ForDeclarations.$$$reportNull$$$0(0);
            }
            if (annotationChecker == null) {
                ForDeclarations.$$$reportNull$$$0(1);
            }
            super(components, annotationChecker);
        }

        @Override
        protected ExpressionTypingVisitorForStatements getStatementVisitor(@NotNull ExpressionTypingContext context) {
            if (context == null) {
                ForDeclarations.$$$reportNull$$$0(2);
            }
            return this.createStatementVisitor(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationChecker";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForDeclarations";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStatementVisitor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

