/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerBuilder;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0017\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0002J,\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010%\u001a\u00020$2\u0006\u0010\f\u001a\u00020&2\u0006\u0010'\u001a\u00020\bH\u0016J(\u0010%\u001a\u00020$2\u0006\u0010\f\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u001c2\b\u0010)\u001a\u0004\u0018\u00010*J\u0018\u0010+\u001a\u0004\u0018\u00010\u0011*\u00020,2\b\b\u0002\u0010-\u001a\u00020\u001cH\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "checkReservedYield", "", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "expression", "Lcom/intellij/psi/PsiElement;", "checkTypesForReturnStatements", "function", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "actualReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "collectReturns", "", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "computeReturnType", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionTypeExpected", "", "computeReturnTypeBasedOnReturnExpressions", "typeOfBodyExpression", "computeUnsafeReturnType", "expectedReturnType", "createFunctionLiteralDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "data", "isDeclaration", "statementScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;", "createFunctionType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "suspendFunction", "kotlin-compiler"})
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext data) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return this.visitNamedFunction(function2, data, false, null);
    }

    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull ExpressionTypingContext context, boolean isDeclaration, @Nullable LexicalWritableScope statementScope) {
        SimpleFunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (!isDeclaration) {
            if (!function2.getTypeParameters().isEmpty()) {
                context.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function2)));
            }
            if (function2.getName() != null) {
                BindingTrace bindingTrace = context.trace;
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                bindingTrace.report(Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(psiElement));
            }
            for (KtParameter parameter : function2.getValueParameters()) {
                if (parameter.hasDefaultValue()) {
                    context.trace.report(Errors.ANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)parameter)));
                }
                if (!parameter.isVarArg()) continue;
                context.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
        if (isDeclaration) {
            boolean bl;
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo);
            boolean bl2 = bl = statementScope != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "statementScope must be not null for function: " + function2.getName() + " at location " + DiagnosticUtils.atLocation(function2);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            LexicalWritableScope lexicalWritableScope = statementScope;
            if (lexicalWritableScope == null) {
                Intrinsics.throwNpe();
            }
            lexicalWritableScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            KotlinType kotlinType = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function2, bindingTrace, dataFlowInfo, kotlinType);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        if (!function2.hasDeclaredReturnType() && !function2.hasBlockBody()) {
            ForceResolveUtil.forceResolveAllContents(functionDescriptor.getReturnType());
        } else {
            LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace, this.components.overloadChecker);
            this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function2, functionDescriptor, context.dataFlowInfo, null, context.trace);
        }
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        List<KtParameter> list2 = function2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "function.valueParameters");
        List<ValueParameterDescriptor> list3 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "functionDescriptor.valueParameters");
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        valueParameterResolver.resolveValueParameters(list2, list3, lexicalScope, dataFlowInfo, bindingTrace);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(function2, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration = function2;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        identifierChecker.checkDeclaration(ktDeclaration, bindingTrace2);
        DeclarationsCheckerBuilder declarationsCheckerBuilder = this.components.declarationsCheckerBuilder;
        BindingTrace bindingTrace3 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace3, "context.trace");
        declarationsCheckerBuilder.withTrace(bindingTrace3).checkFunction(function2, functionDescriptor);
        if (isDeclaration) {
            return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function2, context), context);
        }
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.createCheckedTypeInfo(FunctionsTypingVisitor.createFunctionType$default(this, functionDescriptor, false, 1, null), context, function2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "components.dataFlowAnaly\u2026ype(), context, function)");
        return kotlinTypeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType createFunctionType(@NotNull SimpleFunctionDescriptor $receiver, boolean suspendFunction) {
        Collection<KotlinType> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        KotlinBuiltIns kotlinBuiltIns = this.components.builtIns;
        Intrinsics.checkExpressionValueIsNotNull(kotlinBuiltIns, "components.builtIns");
        ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getExtensionReceiverParameter();
        Iterable iterable = $receiver.getValueParameters();
        KotlinType kotlinType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        KotlinBuiltIns kotlinBuiltIns2 = kotlinBuiltIns;
        void var4_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            KotlinType kotlinType2 = it.getType();
            collection.add(kotlinType2);
        }
        collection = (List)destination$iv$iv;
        KotlinType kotlinType3 = $receiver.getReturnType();
        if (kotlinType3 == null) {
            return null;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns2, annotations2, kotlinType, (List<? extends KotlinType>)collection, null, kotlinType3, suspendFunction);
    }

    static /* bridge */ /* synthetic */ KotlinType createFunctionType$default(FunctionsTypingVisitor functionsTypingVisitor, SimpleFunctionDescriptor simpleFunctionDescriptor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return functionsTypingVisitor.createFunctionType(simpleFunctionDescriptor, bl);
    }

    @Override
    @Nullable
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        PsiElement psiElement = expression;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        KtPsiUtilKt.checkReservedYieldBeforeLambda(psiElement, bindingTrace);
        if (!expression.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType expectedType = context.expectedType;
        boolean functionTypeExpected = !TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isBuiltinFunctionalType(expectedType);
        boolean suspendFunctionTypeExpected = !TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isSuspendFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression, context);
        Iterable $receiver$iv = expression.getValueParameters();
        for (Object element$iv : $receiver$iv) {
            KtParameter it = (KtParameter)element$iv;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            KtParameter ktParameter = it;
            Intrinsics.checkExpressionValueIsNotNull(ktParameter, "it");
            KtDeclaration ktDeclaration = ktParameter;
            BindingTrace bindingTrace2 = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
            identifierChecker.checkDeclaration(ktDeclaration, bindingTrace2);
            KtParameter ktParameter2 = it;
            Intrinsics.checkExpressionValueIsNotNull(ktParameter2, "it");
            KtNamedDeclaration ktNamedDeclaration = ktParameter2;
            BindingTrace bindingTrace3 = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace3, "context.trace");
            DiagnosticSink diagnosticSink = bindingTrace3;
            LanguageVersionSettings languageVersionSettings = this.components.languageVersionSettings;
            Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "components.languageVersionSettings");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, true);
        }
        KotlinType safeReturnType = this.computeReturnType(expression, context, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        KotlinType kotlinType = this.createFunctionType(functionDescriptor, suspendFunctionTypeExpected);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType resultType = kotlinType;
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression);
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtLambdaExpression expression, ExpressionTypingContext context) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        AnnotationResolver annotationResolver = this.components.annotationResolver;
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        List<KtAnnotationEntry> list2 = KtPsiUtilKt.getAnnotationEntries(expression);
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(declarationDescriptor, annotationResolver.resolveAnnotationsWithArguments(lexicalScope, list2, bindingTrace), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(functionLiteral), !TypeUtils.noExpectedType(context.expectedType) && FunctionTypesKt.isSuspendFunctionType(context.expectedType));
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor2 = context.scope.getOwnerDescriptor();
        LexicalScope lexicalScope2 = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope2, "context.scope");
        KtFunctionLiteral ktFunctionLiteral = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionLiteral, "functionLiteral");
        KtFunction ktFunction = ktFunctionLiteral;
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor2, lexicalScope2, ktFunction, simpleFunctionDescriptorImpl, bindingTrace2, kotlinType);
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final KotlinType computeReturnType(KtLambdaExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType;
        KotlinType expectedReturnType = functionTypeExpected ? FunctionTypesKt.getReturnTypeFromFunctionType(context.expectedType) : null;
        KotlinType returnType = this.computeUnsafeReturnType(expression, context, functionDescriptor, expectedReturnType);
        if (!expression.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            KotlinType kotlinType2 = expectedReturnType;
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (!TypeUtils.noExpectedType(kotlinType2) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                SimpleType simpleType2 = this.components.builtIns.getUnitType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "components.builtIns.unitType");
                return simpleType2;
            }
        }
        if ((kotlinType = returnType) == null) {
            SimpleType simpleType3 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(simpleType3, "CANT_INFER_FUNCTION_PARAM_TYPE");
            kotlinType = simpleType3;
        }
        return kotlinType;
    }

    private final KotlinType computeUnsafeReturnType(KtLambdaExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        KotlinType kotlinType = expectedReturnType;
        if (kotlinType == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "NO_EXPECTED_TYPE");
            kotlinType = simpleType2;
        }
        KotlinType expectedType = kotlinType;
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace, this.components.overloadChecker);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(functionInnerScope)).replaceExpectedType(expectedType);
        context.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType);
        ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
        KtBlockExpression ktBlockExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression == null) {
            Intrinsics.throwNpe();
        }
        KotlinType typeOfBodyExpression = expressionTypingServices.getBlockReturnedType(ktBlockExpression, CoercionStrategy.COERCION_TO_UNIT, newContext).getType();
        KtFunctionLiteral ktFunctionLiteral = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionLiteral, "functionLiteral");
        return this.computeReturnTypeBasedOnReturnExpressions(ktFunctionLiteral, context, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context, KotlinType typeOfBodyExpression) {
        KtExpression returnedExpression;
        ArrayList returnedExpressionTypes = Lists.newArrayList();
        boolean hasEmptyReturn = false;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, bindingTrace);
        for (KtReturnExpression returnExpression : returnExpressions) {
            returnedExpression = returnExpression.getReturnedExpression();
            if (returnedExpression == null) {
                hasEmptyReturn = true;
                continue;
            }
            CollectionsKt.addIfNotNull(returnedExpressionTypes, context.trace.getType(returnedExpression));
        }
        if (hasEmptyReturn) {
            for (KtReturnExpression returnExpression : returnExpressions) {
                KotlinType type2;
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null || (type2 = context.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                context.trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnedExpression), this.components.builtIns.getUnitType()));
            }
            return this.components.builtIns.getUnitType();
        }
        CollectionsKt.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
        if (returnedExpressionTypes.isEmpty()) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        KtBlockExpression bodyExpression;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression ktBlockExpression = bodyExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression != null) {
            Void cfr_ignored_0 = (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

                @Nullable
                public Void visitReturnExpression(@NotNull KtReturnExpression expression, @NotNull List<KtReturnExpression> data) {
                    Intrinsics.checkParameterIsNotNull(expression, "expression");
                    Intrinsics.checkParameterIsNotNull(data, "data");
                    data.add(expression);
                    return null;
                }
            }, result2);
        }
        Iterable iterable = $receiver$iv = (Iterable)result2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiElement psiElement;
            KtReturnExpression it = (KtReturnExpression)element$iv$iv;
            if (it.getTargetLabel() != null) {
                KtSimpleNameExpression ktSimpleNameExpression;
                KtSimpleNameExpression it2 = ktSimpleNameExpression;
                psiElement = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it2);
            } else {
                psiElement = null;
            }
            if (!Intrinsics.areEqual(psiElement, functionLiteral)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void checkTypesForReturnStatements(@NotNull KtDeclarationWithBody function2, @NotNull BindingTrace trace, @NotNull KotlinType actualReturnType) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(actualReturnType, "actualReturnType");
        if (function2.hasBlockBody()) {
            return;
        }
        if (!(function2 instanceof KtNamedFunction && ((KtNamedFunction)function2).getTypeReference() == null || function2 instanceof KtPropertyAccessor && ((KtPropertyAccessor)function2).getReturnTypeReference() != null)) {
            return;
        }
        KtExpression ktExpression = function2.getBodyExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression bodyExpression = ktExpression;
        ArrayList returns = new ArrayList();
        bodyExpression.accept((KtVisitor)new KtTreeVisitor<Boolean>(function2, trace, returns){
            final /* synthetic */ KtDeclarationWithBody $function;
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ ArrayList $returns;

            @Nullable
            public Void visitReturnExpression(@NotNull KtReturnExpression expression, boolean data) {
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                KtSimpleNameExpression label = expression.getTargetLabel();
                if (label != null && Intrinsics.areEqual((PsiElement)this.$trace.get(BindingContext.LABEL_TARGET, label), this.$function) || label == null && data) {
                    this.$returns.add(expression);
                }
                return (Void)super.visitReturnExpression(expression, data);
            }

            @Nullable
            public Void visitNamedFunction(@NotNull KtNamedFunction function2, boolean data) {
                Intrinsics.checkParameterIsNotNull(function2, "function");
                return (Void)super.visitNamedFunction(function2, false);
            }
            {
                this.$function = $captured_local_variable$0;
                this.$trace = $captured_local_variable$1;
                this.$returns = $captured_local_variable$2;
            }
        }, true);
        for (KtReturnExpression returnForCheck : returns) {
            KotlinType expressionType;
            KtExpression expression = returnForCheck.getReturnedExpression();
            if (expression == null) {
                if (TypeUtilsKt.isUnit(actualReturnType)) continue;
                trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnForCheck), actualReturnType));
                continue;
            }
            if (trace.getType(expression) == null) {
                continue;
            }
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, actualReturnType)) continue;
            trace.report(Errors.TYPE_MISMATCH.on((KtExpression)((PsiElement)expression), expressionType, actualReturnType));
        }
    }

    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        super(facade);
    }
}

