/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaI18nizeQuickFixDialog
extends I18nizeQuickFixDialog {
    private final PsiLiteralExpression myLiteralExpression;
    private final JLabel myPreviewLabel;
    private final JPanel myHyperLinkPanel;
    private final JPanel myResourceBundleSuggester;
    private EditorComboBox myRBEditorTextField;
    private final JPanel myJavaCodeInfoPanel;
    private final JPanel myPreviewPanel;
    private PsiClassType myResourceBundleType;
    protected final ResourceBundleManager myResourceBundleManager;
    private final boolean myShowJavaCodeInfo;
    private final boolean myShowPreview;
    @NonNls
    public static final String PROPERTY_KEY_OPTION_KEY = "PROPERTY_KEY";
    @NonNls
    private static final String RESOURCE_BUNDLE_OPTION_KEY = "RESOURCE_BUNDLE";
    @NonNls
    public static final String PROPERTY_VALUE_ATTR = "PROPERTY_VALUE";

    public JavaI18nizeQuickFixDialog(@NotNull Project project, @NotNull PsiFile context, @Nullable PsiLiteralExpression literalExpression, String defaultPropertyValue, I18nizeQuickFixDialog.DialogCustomization customization, boolean showJavaCodeInfo, boolean showPreview) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/i18n/JavaI18nizeQuickFixDialog", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/i18n/JavaI18nizeQuickFixDialog", "<init>"));
        }
        super(project, context, defaultPropertyValue, customization, true);
        ResourceBundleManager resourceBundleManager = null;
        try {
            resourceBundleManager = ResourceBundleManager.getManager(context);
            LOG.assertTrue(resourceBundleManager != null);
        }
        catch (ResourceBundleManager.ResourceBundleNotFoundException e) {
            LOG.error((Throwable)e);
        }
        this.myResourceBundleManager = resourceBundleManager;
        JavaExtensibilityData data = new JavaExtensibilityData();
        this.myExtensibilityPanel.setLayout(new BorderLayout());
        this.myExtensibilityPanel.add((Component)data.myPanel, "Center");
        this.myJavaCodeInfoPanel = data.myJavaCodeInfoPanel;
        this.myPreviewPanel = data.myPreviewPanel;
        this.myHyperLinkPanel = data.myHyperLinkPanel;
        this.myResourceBundleSuggester = data.myResourceBundleSuggester;
        this.myPreviewLabel = data.myPreviewLabel;
        this.myLiteralExpression = literalExpression;
        this.myShowPreview = showPreview;
        this.myResourceBundleSuggester.setLayout(new BorderLayout());
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        PsiClass resourceBundle = this.myResourceBundleManager.getResourceBundle();
        boolean bl = this.myShowJavaCodeInfo = showJavaCodeInfo && this.myResourceBundleManager.canShowJavaCodeInfo();
        if (this.myShowJavaCodeInfo) {
            LOG.assertTrue(resourceBundle != null);
            this.myResourceBundleType = factory.createType(resourceBundle);
            String defaultVarName = "resourceBundle";
            JavaCodeFragmentFactory codeFragmentFactory = JavaCodeFragmentFactory.getInstance((Project)project);
            PsiExpressionCodeFragment expressionCodeFragment = codeFragmentFactory.createExpressionCodeFragment(defaultVarName, (PsiElement)this.myLiteralExpression, (PsiType)this.myResourceBundleType, true);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)expressionCodeFragment);
            this.myRBEditorTextField = new EditorComboBox(document, this.myProject, (FileType)StdFileTypes.JAVA);
            this.myResourceBundleSuggester.add((Component)this.myRBEditorTextField, "Center");
            this.suggestAvailableResourceBundleExpressions();
            this.myRBEditorTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    JavaI18nizeQuickFixDialog.this.somethingChanged();
                }
            });
        }
        this.myHyperLinkPanel.setLayout(new BorderLayout());
        final String templateName = this.getTemplateName();
        if (templateName != null) {
            HyperlinkLabel link = new HyperlinkLabel(CodeInsightBundle.message((String)"i18nize.dialog.template.link.label", (Object[])new Object[0]));
            link.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    FileTemplateConfigurable configurable = new FileTemplateConfigurable(JavaI18nizeQuickFixDialog.this.myProject);
                    FileTemplate template = FileTemplateManager.getInstance((Project)JavaI18nizeQuickFixDialog.this.myProject).getCodeTemplate(templateName);
                    SwingUtilities.invokeLater(() -> configurable.setTemplate(template, null));
                    boolean ok = ShowSettingsUtil.getInstance().editConfigurable((Component)JavaI18nizeQuickFixDialog.this.myPanel, (Configurable)configurable);
                    if (ok) {
                        FileTemplateManager.getInstance((Project)JavaI18nizeQuickFixDialog.this.myProject).saveAllTemplates();
                        JavaI18nizeQuickFixDialog.this.somethingChanged();
                        if (JavaI18nizeQuickFixDialog.this.myShowJavaCodeInfo) {
                            JavaI18nizeQuickFixDialog.this.suggestAvailableResourceBundleExpressions();
                        }
                    }
                }
            });
            this.myHyperLinkPanel.add((Component)link, "Center");
        }
        if (!this.myShowJavaCodeInfo) {
            this.myJavaCodeInfoPanel.setVisible(false);
        }
        if (!this.myShowPreview) {
            this.myPreviewPanel.setVisible(false);
        }
        this.init();
    }

    public static boolean isAvailable(PsiFile file) {
        Project project = file.getProject();
        String title = CodeInsightBundle.message((String)"i18nize.dialog.error.jdk.title", (Object[])new Object[0]);
        try {
            return ResourceBundleManager.getManager(file) != null;
        }
        catch (ResourceBundleManager.ResourceBundleNotFoundException e) {
            IntentionAction fix = e.getFix();
            if (fix != null && Messages.showOkCancelDialog((Project)project, (String)e.getMessage(), (String)title, (Icon)Messages.getErrorIcon()) == 0) {
                try {
                    fix.invoke(project, null, file);
                    return false;
                }
                catch (IncorrectOperationException e1) {
                    LOG.error((Throwable)e1);
                }
            }
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)title);
            return false;
        }
    }

    public PropertyCreationHandler getPropertyCreationHandler() {
        PropertyCreationHandler handler = this.myResourceBundleManager.getPropertyCreationHandler();
        return handler != null ? handler : JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER;
    }

    private void suggestAvailableResourceBundleExpressions() {
        Set<String> result;
        String templateName = this.getTemplateName();
        if (templateName == null) {
            return;
        }
        if (this.myShowJavaCodeInfo) {
            FileTemplate template = FileTemplateManager.getInstance((Project)this.myProject).getCodeTemplate(templateName);
            boolean showResourceBundleSuggester = template.getText().contains("${RESOURCE_BUNDLE}");
            this.myJavaCodeInfoPanel.setVisible(showResourceBundleSuggester);
        }
        if ((result = JavaI18nUtil.suggestExpressionOfType(this.myResourceBundleType, this.myLiteralExpression)).isEmpty()) {
            result.add(this.getResourceBundleText());
        }
        this.myRBEditorTextField.setHistory(ArrayUtil.toStringArray(result));
        SwingUtilities.invokeLater(() -> this.myRBEditorTextField.setSelectedIndex(0));
    }

    protected void somethingChanged() {
        if (this.myShowPreview) {
            this.myPreviewLabel.setText(this.getI18nizedText());
        }
        super.somethingChanged();
    }

    @Nullable
    protected String getTemplateName() {
        return this.myResourceBundleManager.getTemplateName();
    }

    protected String defaultSuggestPropertyKey(String value) {
        return this.myResourceBundleManager.suggestPropertyKey(value);
    }

    protected List<String> defaultSuggestPropertiesFiles() {
        return this.myResourceBundleManager.suggestPropertiesFiles();
    }

    public String getI18nizedText() {
        String propertyKey = StringUtil.escapeStringCharacters((String)this.getKey());
        I18nizedTextGenerator textGenerator = this.myResourceBundleManager.getI18nizedTextGenerator();
        if (textGenerator != null) {
            return this.generateText(textGenerator, propertyKey, this.getPropertiesFile(), this.myLiteralExpression);
        }
        String templateName = this.getTemplateName();
        LOG.assertTrue(templateName != null);
        FileTemplate template = FileTemplateManager.getInstance((Project)this.myProject).getCodeTemplate(templateName);
        THashMap attributes = new THashMap();
        attributes.put(PROPERTY_KEY_OPTION_KEY, propertyKey);
        attributes.put(RESOURCE_BUNDLE_OPTION_KEY, this.getResourceBundleText());
        attributes.put(PROPERTY_VALUE_ATTR, StringUtil.escapeStringCharacters((String)this.myDefaultPropertyValue));
        this.addAdditionalAttributes((Map<String, String>)attributes);
        String text = null;
        try {
            text = template.getText((Map)attributes);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return text;
    }

    protected String generateText(I18nizedTextGenerator textGenerator, String propertyKey, PropertiesFile propertiesFile, PsiLiteralExpression literalExpression) {
        return textGenerator.getI18nizedText(propertyKey, propertiesFile, literalExpression);
    }

    protected void addAdditionalAttributes(Map<String, String> attributes) {
    }

    private String getResourceBundleText() {
        return this.myShowJavaCodeInfo ? this.myRBEditorTextField.getText() : null;
    }

    public PsiLiteralExpression getLiteralExpression() {
        return this.myLiteralExpression;
    }

    public PsiExpression[] getParameters() {
        return PsiExpression.EMPTY_ARRAY;
    }

    static class JavaExtensibilityData {
        private JPanel myPreviewPanel;
        private JPanel myJavaCodeInfoPanel;
        private JPanel myPanel;
        private JPanel myHyperLinkPanel;
        private MultiLineLabel myPreviewLabel;
        private JPanel myResourceBundleSuggester;

        JavaExtensibilityData() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JPanel jPanel2;
            JPanel jPanel3;
            MultiLineLabel multiLineLabel;
            JPanel jPanel4;
            JPanel jPanel5;
            this.myPanel = jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.setMinimumSize(new Dimension(145, 182));
            jPanel5.setPreferredSize(new Dimension(145, 182));
            this.myPreviewPanel = jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
            jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
            jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(100, -1), null, null));
            jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/CodeInsightBundle").getString("i18n.quickfix.preview.panel.title"), (int)0, (int)0, null, null));
            this.myPreviewLabel = multiLineLabel = new MultiLineLabel();
            multiLineLabel.setText("####");
            jPanel4.add((Component)multiLineLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, new Dimension(75, -1), null, null));
            this.myHyperLinkPanel = jPanel3 = new JPanel();
            jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(45, -1), null));
            this.myJavaCodeInfoPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), 4, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, new Dimension(100, -1), null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/CodeInsightBundle").getString("i18n.quickfix.code.panel.title"), (int)0, (int)0, null, null));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("i18n.quickfix.code.panel.resource.bundle.expression.label"));
            jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
            this.myResourceBundleSuggester = jPanel = new JPanel();
            jPanel6.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel5.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            jLabel.setLabelFor(jPanel);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

