/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskRepository;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TaskManager {
    public static TaskManager getManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/TaskManager", "getManager"));
        }
        return (TaskManager)project.getComponent(TaskManager.class);
    }

    public abstract List<Task> getIssues(@Nullable String var1);

    public abstract List<Task> getIssues(@Nullable String var1, boolean var2);

    public abstract List<Task> getIssues(@Nullable String var1, int var2, int var3, boolean var4, @NotNull ProgressIndicator var5, boolean var6);

    public abstract List<Task> getCachedIssues();

    public abstract List<Task> getCachedIssues(boolean var1);

    @Nullable
    public abstract Task updateIssue(@NotNull String var1);

    public abstract List<LocalTask> getLocalTasks();

    public abstract List<LocalTask> getLocalTasks(boolean var1);

    public abstract LocalTask addTask(Task var1);

    public abstract LocalTask createLocalTask(String var1);

    public abstract LocalTask activateTask(@NotNull Task var1, boolean var2);

    @NotNull
    public abstract LocalTask getActiveTask();

    @Nullable
    public abstract LocalTask findTask(String var1);

    public abstract void updateIssues(@Nullable Runnable var1);

    public abstract boolean isVcsEnabled();

    public abstract AbstractVcs getActiveVcs();

    public abstract boolean isLocallyClosed(LocalTask var1);

    @Nullable
    public abstract LocalTask getAssociatedTask(LocalChangeList var1);

    public abstract void trackContext(LocalChangeList var1);

    public abstract void disassociateFromTask(LocalChangeList var1);

    public abstract void removeTask(LocalTask var1);

    @Deprecated
    public abstract void addTaskListener(TaskListener var1);

    public abstract void addTaskListener(@NotNull TaskListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeTaskListener(TaskListener var1);

    public abstract TaskRepository[] getAllRepositories();

    public abstract boolean testConnection(TaskRepository var1);

    public static enum VcsOperation {
        CREATE_BRANCH,
        CREATE_CHANGELIST,
        DO_NOTHING;

    }
}

