/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;

public class ResolveAction
extends BasicAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = SvnBundle.message("action.name.resolve.conflict", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/ResolveAction", "getActionName"));
        }
        return string;
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ResolveAction", "isEnabled"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ResolveAction", "isEnabled"));
        }
        FileStatus status = FileStatusManager.getInstance((Project)vcs.getProject()).getStatus(file);
        return file.isDirectory() || FileStatus.MERGED_WITH_CONFLICTS.equals(status) || FileStatus.MERGED_WITH_BOTH_CONFLICTS.equals(status);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ResolveAction", "perform"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/actions/ResolveAction", "perform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/actions/ResolveAction", "perform"));
        }
        this.batchPerform(vcs, (VirtualFile[])ContainerUtil.ar((Object[])new VirtualFile[]{file}), context);
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ResolveAction", "batchPerform"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/actions/ResolveAction", "batchPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/actions/ResolveAction", "batchPerform"));
        }
        boolean hasDirs = ContainerUtil.exists((Object[])files, VirtualFile::isDirectory);
        ArrayList fileList = ContainerUtil.newArrayList();
        if (!hasDirs) {
            Collections.addAll(fileList, files);
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/idea/svn/actions/ResolveAction", "lambda$batchPerform$1"));
                }
                if (vcs == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ResolveAction", "lambda$batchPerform$1"));
                }
                for (VirtualFile file : files) {
                    if (file.isDirectory()) {
                        ProjectLevelVcsManager.getInstance((Project)vcs.getProject()).iterateVcsRoot(file, filePath -> {
                            if (vcs == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ResolveAction", "lambda$null$0"));
                            }
                            ProgressManager.checkCanceled();
                            VirtualFile fileOrDir = filePath.getVirtualFile();
                            if (fileOrDir != null && !fileOrDir.isDirectory() && this.isEnabled(vcs, fileOrDir) && !fileList.contains(fileOrDir)) {
                                fileList.add(fileOrDir);
                            }
                            return true;
                        });
                        continue;
                    }
                    if (fileList.contains(file)) continue;
                    fileList.add(file);
                }
            }, SvnBundle.message("progress.searching.for.files.with.conflicts", new Object[0]), true, vcs.getProject());
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)vcs.getProject()).ensureFilesWritable((Collection)fileList);
        fileList.removeAll(Arrays.asList(status.getReadonlyFiles()));
        AbstractVcsHelper.getInstance((Project)vcs.getProject()).showMergeDialog((List)fileList, (MergeProvider)new SvnMergeProvider(vcs.getProject()));
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }
}

