/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.tmatesoft.svn.core.wc.SVNRevision;

public abstract class BaseSvnFileAnnotation
extends FileAnnotation {
    protected final String myContents;
    protected final VcsRevisionNumber myBaseRevision;
    private final MyPartiallyCreatedInfos myInfos;
    protected final SvnVcs myVcs;
    private final Map<Long, SvnFileRevision> myRevisionMap;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect ORIGINAL_REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;
    private final SvnConfiguration myConfiguration;
    private boolean myShowMergeSources;
    private SvnRevisionNumber myFirstRevisionNumber;

    public void setRevision(long revision, SvnFileRevision svnRevision) {
        this.myRevisionMap.put(revision, svnRevision);
    }

    public SvnFileRevision getRevision(long revision) {
        return this.myRevisionMap.get(revision);
    }

    public void setFirstRevision(SVNRevision svnRevision) {
        this.myFirstRevisionNumber = new SvnRevisionNumber(svnRevision);
    }

    public SvnRevisionNumber getFirstRevisionNumber() {
        return this.myFirstRevisionNumber;
    }

    public BaseSvnFileAnnotation(@NotNull SvnVcs vcs, String contents, VcsRevisionNumber baseRevision) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation", "<init>"));
        }
        super(vcs.getProject());
        this.myRevisionMap = new HashMap<Long, SvnFileRevision>();
        this.DATE_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.DATE, true){

            @Override
            public String getValue(@NotNull CommitInfo info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$1", "getValue"));
                }
                return DateFormatUtil.formatPrettyDate((Date)info.getDate());
            }
        };
        this.REVISION_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.REVISION, false){

            @Override
            public String getValue(@NotNull CommitInfo info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$2", "getValue"));
                }
                return String.valueOf(info.getRevision());
            }
        };
        this.ORIGINAL_REVISION_ASPECT = new SvnAnnotationAspect(SvnBundle.message("annotation.original.revision", new Object[0]), false){

            @Override
            public String getValue(int lineNumber) {
                long value = BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNumber);
                return value == -1L ? "" : String.valueOf(value);
            }

            @Override
            protected long getRevision(int lineNum) {
                return BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNum);
            }

            public String getTooltipText(int lineNumber) {
                if (!BaseSvnFileAnnotation.this.myInfos.isValid(lineNumber)) {
                    return "";
                }
                CommitInfo info = BaseSvnFileAnnotation.this.myInfos.get(lineNumber);
                if (info == null) {
                    return null;
                }
                SvnFileRevision revision = (SvnFileRevision)BaseSvnFileAnnotation.this.myRevisionMap.get(info.getRevision());
                return revision != null ? XmlStringUtil.escapeString((String)("Revision " + info.getRevision() + ": " + revision.getCommitMessage())) : "";
            }
        };
        this.AUTHOR_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

            @Override
            public String getValue(@NotNull CommitInfo info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$4", "getValue"));
                }
                return info.getAuthor();
            }
        };
        this.myVcs = vcs;
        this.myContents = contents;
        this.myBaseRevision = baseRevision;
        this.myConfiguration = vcs.getSvnConfiguration();
        this.myShowMergeSources = this.myConfiguration.isShowMergeSourcesInAnnotate();
        this.myInfos = new MyPartiallyCreatedInfos();
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    public String getToolTip(int lineNumber) {
        CommitInfo info = this.myInfos.getOrNull(lineNumber);
        if (info == null) {
            return "";
        }
        SvnFileRevision revision = this.myRevisionMap.get(info.getRevision());
        if (revision != null) {
            String prefix = this.myInfos.getAnnotationSource(lineNumber).showMerged() ? "Merge source revision" : "Revision";
            return prefix + " " + info.getRevision() + ": " + revision.getCommitMessage();
        }
        return "";
    }

    public String getAnnotatedContent() {
        return this.myContents;
    }

    public void setLineInfo(int lineNumber, @NotNull CommitInfo info, @Nullable CommitInfo mergeInfo) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation", "setLineInfo"));
        }
        this.myInfos.appendNumberedLineInfo(lineNumber, info, mergeInfo);
    }

    @Nullable
    public VcsRevisionNumber originalRevision(int lineNumber) {
        SvnFileRevision revision = this.myInfos.isValid(lineNumber) ? this.myRevisionMap.get(this.myInfos.originalRevision(lineNumber)) : null;
        return revision != null ? revision.getRevisionNumber() : null;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        CommitInfo info = this.myInfos.getOrNull(lineNumber);
        return info != null && info.getRevision() >= 0L ? new SvnRevisionNumber(SVNRevision.create((long)info.getRevision())) : null;
    }

    public Date getLineDate(int lineNumber) {
        CommitInfo info = this.myInfos.getOrNull(lineNumber);
        return info != null ? info.getDate() : null;
    }

    public List<VcsFileRevision> getRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>(this.myRevisionMap.values());
        Collections.sort(result, new Comparator<VcsFileRevision>(){

            @Override
            public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                return o2.getRevisionNumber().compareTo((Object)o1.getRevisionNumber());
            }
        });
        return result;
    }

    @Nullable
    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        if (!this.myShowMergeSources) {
            return null;
        }
        return new AnnotationSourceSwitcher(){

            @NotNull
            public AnnotationSource getAnnotationSource(int lineNumber) {
                AnnotationSource annotationSource = BaseSvnFileAnnotation.this.myInfos.getAnnotationSource(lineNumber);
                if (annotationSource == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$6", "getAnnotationSource"));
                }
                return annotationSource;
            }

            public boolean mergeSourceAvailable(int lineNumber) {
                return BaseSvnFileAnnotation.this.myInfos.mergeSourceAvailable(lineNumber);
            }

            @NotNull
            public LineAnnotationAspect getRevisionAspect() {
                LineAnnotationAspect lineAnnotationAspect = BaseSvnFileAnnotation.this.ORIGINAL_REVISION_ASPECT;
                if (lineAnnotationAspect == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$6", "getRevisionAspect"));
                }
                return lineAnnotationAspect;
            }

            @NotNull
            public AnnotationSource getDefaultSource() {
                AnnotationSource annotationSource = AnnotationSource.getInstance((boolean)BaseSvnFileAnnotation.this.myShowMergeSources);
                if (annotationSource == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$6", "getDefaultSource"));
                }
                return annotationSource;
            }

            public void switchTo(AnnotationSource source) {
                BaseSvnFileAnnotation.this.myInfos.setShowMergeSource(source.showMerged());
            }
        };
    }

    public int getLineCount() {
        return this.myInfos.size();
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }

    protected abstract void showAllAffectedPaths(SvnRevisionNumber var1);

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    private static class MyPartiallyCreatedInfos {
        private boolean myShowMergeSource;
        private final Map<Integer, CommitInfo> myMappedLineInfo;
        private final Map<Integer, CommitInfo> myMergeSourceInfos = ContainerUtil.newHashMap();
        private int myMaxIdx = 0;

        private MyPartiallyCreatedInfos() {
            this.myMappedLineInfo = ContainerUtil.newHashMap();
        }

        void setShowMergeSource(boolean showMergeSource) {
            this.myShowMergeSource = showMergeSource;
        }

        int size() {
            return this.myMaxIdx + 1;
        }

        void appendNumberedLineInfo(int lineNumber, @NotNull CommitInfo info, @Nullable CommitInfo mergeInfo) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$MyPartiallyCreatedInfos", "appendNumberedLineInfo"));
            }
            if (this.myMappedLineInfo.get(lineNumber) != null) {
                return;
            }
            this.myMaxIdx = this.myMaxIdx < lineNumber ? lineNumber : this.myMaxIdx;
            this.myMappedLineInfo.put(lineNumber, info);
            if (mergeInfo != null) {
                this.myMergeSourceInfos.put(lineNumber, mergeInfo);
            }
        }

        CommitInfo get(int idx) {
            CommitInfo lineInfo;
            if (this.myShowMergeSource && (lineInfo = this.myMergeSourceInfos.get(idx)) != null) {
                return lineInfo;
            }
            return this.myMappedLineInfo.get(idx);
        }

        @Nullable
        CommitInfo getOrNull(int lineNumber) {
            return this.isValid(lineNumber) ? this.get(lineNumber) : null;
        }

        private boolean isValid(int lineNumber) {
            return lineNumber >= 0 && lineNumber < this.size();
        }

        AnnotationSource getAnnotationSource(int line) {
            return this.myShowMergeSource ? AnnotationSource.getInstance((boolean)this.myMergeSourceInfos.containsKey(line)) : AnnotationSource.LOCAL;
        }

        public long originalRevision(int line) {
            CommitInfo info = line < this.size() ? this.myMappedLineInfo.get(line) : null;
            return info == null ? -1L : info.getRevision();
        }

        public boolean mergeSourceAvailable(int lineNumber) {
            return this.myMergeSourceInfos.containsKey(lineNumber);
        }
    }

    private abstract class SvnAnnotationAspect
    extends LineAnnotationAspectAdapter {
        public SvnAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected long getRevision(int lineNum) {
            CommitInfo lineInfo = BaseSvnFileAnnotation.this.myInfos.get(lineNum);
            return lineInfo == null ? -1L : lineInfo.getRevision();
        }

        protected void showAffectedPaths(int lineNum) {
            long revision;
            if (BaseSvnFileAnnotation.this.myInfos.isValid(lineNum) && (revision = this.getRevision(lineNum)) >= 0L) {
                BaseSvnFileAnnotation.this.showAllAffectedPaths(new SvnRevisionNumber(SVNRevision.create((long)revision)));
            }
        }

        public String getValue(int lineNumber) {
            CommitInfo info = BaseSvnFileAnnotation.this.myInfos.getOrNull(lineNumber);
            return info == null ? "" : this.getValue(info);
        }

        public String getValue(@NotNull CommitInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$SvnAnnotationAspect", "getValue"));
            }
            return "";
        }
    }
}

