/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SSHUtil;
import com.intellij.util.WaitForProgressToShow;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.BaseTerminalModule;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.dialogs.ServerSSHDialog;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;
import org.tmatesoft.svn.core.SVNURL;

public class TerminalSshModule
extends BaseTerminalModule {
    private static final Pattern UNKNOWN_HOST_MESSAGE = Pattern.compile("The authenticity of host \\'((.*) \\((.*)\\))\\' can\\'t be established\\.\\s?");
    private static final Pattern HOST_FINGERPRINT_MESSAGE = Pattern.compile("(\\w+) key fingerprint is (.*)\\.\\s?");
    private static final Pattern ACCEPT_HOST_PROMPT = Pattern.compile("Are you sure you want to continue connecting \\(yes/no\\)\\?\\s?");
    private String unknownHost;
    private String fingerprintAlgorithm;
    private String hostFingerprint;

    public TerminalSshModule(@NotNull CommandRuntime runtime, @NotNull CommandExecutor executor) {
        if (runtime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "org/jetbrains/idea/svn/commandLine/TerminalSshModule", "<init>"));
        }
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/svn/commandLine/TerminalSshModule", "<init>"));
        }
        super(runtime, executor);
    }

    @Override
    public boolean doHandlePrompt(String line, Key outputType) {
        return this.checkPassphrase(line) || this.checkPassword(line) || this.checkUnknownHost(line);
    }

    private boolean checkPassphrase(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/TerminalSshModule", "checkPassphrase"));
        }
        Matcher matcher = SSHUtil.PASSPHRASE_PROMPT.matcher(line);
        return matcher.matches() && this.handleAuthPrompt(SimpleCredentialsDialog.Mode.SSH_PASSPHRASE, matcher.group(1));
    }

    private boolean checkPassword(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/TerminalSshModule", "checkPassword"));
        }
        Matcher matcher = SSHUtil.PASSWORD_PROMPT.matcher(line);
        return matcher.matches() && this.handleAuthPrompt(SimpleCredentialsDialog.Mode.SSH_PASSWORD, matcher.group(1));
    }

    private boolean checkUnknownHost(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/svn/commandLine/TerminalSshModule", "checkUnknownHost"));
        }
        Matcher unknownHostMatcher = UNKNOWN_HOST_MESSAGE.matcher(line);
        Matcher hostFingerPrintMatcher = HOST_FINGERPRINT_MESSAGE.matcher(line);
        Matcher acceptHostMatcher = ACCEPT_HOST_PROMPT.matcher(line);
        if (unknownHostMatcher.matches()) {
            this.unknownHost = unknownHostMatcher.group(1);
        } else if (hostFingerPrintMatcher.matches()) {
            this.fingerprintAlgorithm = hostFingerPrintMatcher.group(1);
            this.hostFingerprint = hostFingerPrintMatcher.group(2);
        } else if (acceptHostMatcher.matches()) {
            this.handleUnknownHost();
        }
        return unknownHostMatcher.matches() || hostFingerPrintMatcher.matches() || acceptHostMatcher.matches();
    }

    private void handleUnknownHost() {
        final Project project = this.myRuntime.getVcs().getProject();
        final Ref answer = new Ref();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ServerSSHDialog dialog = new ServerSSHDialog(project, true, TerminalSshModule.this.unknownHost, TerminalSshModule.this.fingerprintAlgorithm, TerminalSshModule.this.hostFingerprint);
                dialog.show();
                answer.set((Object)dialog.getResult());
            }
        };
        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command, (ModalityState)ModalityState.any());
        this.unknownHost = null;
        this.fingerprintAlgorithm = null;
        this.hostFingerprint = null;
        this.sendData((Integer)answer.get() == 0 ? "no" : "yes");
    }

    private boolean handleAuthPrompt(@NotNull SimpleCredentialsDialog.Mode mode, @NotNull String key) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/idea/svn/commandLine/TerminalSshModule", "handleAuthPrompt"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/svn/commandLine/TerminalSshModule", "handleAuthPrompt"));
        }
        SVNURL repositoryUrl = this.myExecutor.getCommand().requireRepositoryUrl();
        String auth = this.myRuntime.getAuthenticationService().requestSshCredentials(repositoryUrl.toDecodedString(), mode, key);
        if (!StringUtil.isEmpty((String)auth)) {
            this.sendData(auth);
        } else {
            this.cancelAuthentication();
        }
        return !StringUtil.isEmpty((String)auth);
    }
}

