/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;

public class SvnEditCommitMessageDialog
extends DialogWrapper {
    @Nullable
    private final Project myProject;
    private final String myOldText;
    private CommitMessage myCommitMessage;

    protected SvnEditCommitMessageDialog(@Nullable Project project, long number, String oldText) {
        super(project, false);
        this.myProject = project;
        this.myOldText = oldText;
        this.setTitle(SvnBundle.message("svn.edit.commit.message.title", number));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel parentPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridBagLayout());
        JLabel label1 = new JLabel(SvnBundle.message("svn.edit.commit.message.attention", new Object[0]));
        parentPanel.setMinimumSize(new Dimension(label1.getPreferredSize().width + 50, 150));
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)1), 0, 0);
        label1.setFont(label1.getFont().deriveFont(1));
        labelPanel.add((Component)label1, gb);
        ++gb.gridy;
        gb.insets.top = 5;
        gb.insets.bottom = 3;
        JLabel label2 = new JLabel(SvnBundle.message("svn.edit.commit.message.prompt", new Object[0]));
        labelPanel.add((Component)label2, gb);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)labelPanel, "West");
        parentPanel.add((Component)wrapper, "North");
        this.myCommitMessage = new CommitMessage(this.myProject, false);
        this.myCommitMessage.setText(this.myOldText);
        parentPanel.add((Component)this.myCommitMessage, "Center");
        return parentPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessage.getEditorField();
    }

    @NotNull
    public String getMessage() {
        String string = this.myCommitMessage.getComment();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnEditCommitMessageDialog", "getMessage"));
        }
        return string;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.svn.history.SvnEditCommitMessageDialog";
    }
}

