/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ShowPropertiesDiffAction;
import org.jetbrains.idea.svn.history.PropertyRevision;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.tmatesoft.svn.core.SVNURL;

public class SvnLazyPropertyContentRevision
extends SvnBaseContentRevision
implements PropertyRevision {
    private final VcsRevisionNumber myNumber;
    private final SVNURL myUrl;
    private List<PropertyData> myContent;

    public SvnLazyPropertyContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, VcsRevisionNumber number, SVNURL url) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision", "<init>"));
        }
        super(vcs, file);
        this.myNumber = number;
        this.myUrl = url;
    }

    @Override
    @Nullable
    public List<PropertyData> getProperties() throws VcsException {
        if (this.myContent == null) {
            this.myContent = this.loadContent();
        }
        return this.myContent;
    }

    public String getContent() throws VcsException {
        return ShowPropertiesDiffAction.toSortedStringPresentation(this.getProperties());
    }

    private List<PropertyData> loadContent() throws VcsException {
        Ref ref = new Ref();
        Ref exceptionRef = new Ref();
        Runnable runnable = () -> {
            try {
                ref.set(ShowPropertiesDiffAction.getPropertyList(this.myVcs, this.myUrl, ((SvnRevisionNumber)this.myNumber).getRevision()));
            }
            catch (VcsException e) {
                exceptionRef.set((Object)e);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, SvnBundle.message("progress.title.loading.file.properties", new Object[0]), true, this.myVcs.getProject());
            if (!completed) {
                throw new VcsException("Properties load for revision " + this.getRevisionNumber().asString() + " was canceled.");
            }
        } else {
            runnable.run();
        }
        if (!exceptionRef.isNull()) {
            throw (VcsException)((Object)exceptionRef.get());
        }
        return (List)ref.get();
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = this.myNumber;
        if (vcsRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnLazyPropertyContentRevision", "getRevisionNumber"));
        }
        return vcsRevisionNumber;
    }
}

