/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Intersection {
    @NotNull
    private final Map<String, String> myListComments = ContainerUtil.newHashMap();
    @NotNull
    private final Map<String, List<Change>> myChangesByLists = ContainerUtil.newHashMap();

    public void add(@NotNull LocalChangeList list, @NotNull Change change) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/svn/integrate/Intersection", "add"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/integrate/Intersection", "add"));
        }
        this.myChangesByLists.computeIfAbsent(list.getName(), key -> ContainerUtil.newArrayList()).add(change);
        this.myListComments.put(list.getName(), (String)ObjectUtils.notNull((Object)list.getComment(), (Object)list.getName()));
    }

    @NotNull
    public String getComment(@NotNull String listName) {
        if (listName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listName", "org/jetbrains/idea/svn/integrate/Intersection", "getComment"));
        }
        String string = this.myListComments.get(listName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/Intersection", "getComment"));
        }
        return string;
    }

    @NotNull
    public Map<String, List<Change>> getChangesByLists() {
        Map<String, List<Change>> map = this.myChangesByLists;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/Intersection", "getChangesByLists"));
        }
        return map;
    }

    public boolean isEmpty() {
        return this.myChangesByLists.isEmpty();
    }

    @NotNull
    public List<Change> getAllChanges() {
        List list = ContainerUtil.concat(this.myChangesByLists.values());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/Intersection", "getAllChanges"));
        }
        return list;
    }

    public static boolean isEmpty(@Nullable Intersection intersection) {
        return intersection == null || intersection.isEmpty();
    }
}

