/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.Intersection;
import org.jetbrains.idea.svn.integrate.LocalChangesAction;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class LocalChangesPromptTask
extends BaseMergeTask {
    @Nullable
    private final List<SvnChangeList> myChangeListsToMerge;
    @NotNull
    private final Runnable myCallback;

    public LocalChangesPromptTask(@NotNull QuickMerge mergeProcess, @Nullable List<SvnChangeList> changeListsToMerge, @NotNull Runnable callback) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "<init>"));
        }
        super(mergeProcess);
        this.myChangeListsToMerge = changeListsToMerge;
        this.myCallback = callback;
    }

    @Nullable
    private File getLocalPath(String repositoryRelativePath) {
        String absoluteUrl = SVNPathUtil.append((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)repositoryRelativePath);
        String sourceRelativePath = SVNPathUtil.getRelativePath((String)this.myMergeContext.getSourceUrl(), (String)absoluteUrl);
        return !StringUtil.isEmptyOrSpaces((String)sourceRelativePath) ? new File(this.myMergeContext.getWcInfo().getPath(), sourceRelativePath) : null;
    }

    @Override
    public void run() {
        List localChangeLists = ChangeListManager.getInstance((Project)this.myMergeContext.getProject()).getChangeListsCopy();
        Intersection intersection = this.myChangeListsToMerge != null ? this.getChangesIntersection(localChangeLists, this.myChangeListsToMerge) : LocalChangesPromptTask.getAllChangesIntersection(localChangeLists);
        this.processIntersection(intersection);
    }

    private void processIntersection(@Nullable Intersection intersection) {
        boolean mergeAll = this.myChangeListsToMerge == null;
        LocalChangesAction nextAction = !Intersection.isEmpty(intersection) ? this.myInteraction.selectLocalChangesAction(mergeAll) : LocalChangesAction.continueMerge;
        switch (nextAction) {
            case continueMerge: {
                this.myCallback.run();
                break;
            }
            case shelve: {
                this.myMergeProcess.runInBackground("Shelving local changes before merge", indicator -> {
                    this.shelveChanges(intersection);
                    this.myCallback.run();
                });
                break;
            }
            case inspect: {
                List intersectedPaths = ContainerUtil.sorted((Collection)ChangesUtil.getPaths(intersection.getAllChanges()), (Comparator)FilePathByPathComparator.getInstance());
                this.myInteraction.showIntersectedLocalPaths(intersectedPaths);
                break;
            }
        }
    }

    private void shelveChanges(@NotNull Intersection intersection) throws VcsException {
        if (intersection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intersection", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "shelveChanges"));
        }
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
            ShelveChangesManager shelveManager = ShelveChangesManager.getInstance((Project)this.myMergeContext.getProject());
            for (Map.Entry<String, List<Change>> entry : intersection.getChangesByLists().entrySet()) {
                String shelfName = intersection.getComment(entry.getKey()) + " (auto shelve before merge)";
                shelveManager.shelveChanges((Collection)entry.getValue(), shelfName, true, true);
            }
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @Nullable
    private Intersection getChangesIntersection(@NotNull List<LocalChangeList> localChangeLists, @NotNull List<SvnChangeList> changeListsToMerge) {
        if (localChangeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        if (changeListsToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListsToMerge", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        Set<FilePath> pathsToMerge = this.collectPaths(changeListsToMerge);
        return !changeListsToMerge.isEmpty() ? LocalChangesPromptTask.getChangesIntersection(localChangeLists, (Condition<Change>)((Condition)change -> LocalChangesPromptTask.hasPathToMerge(change, pathsToMerge))) : null;
    }

    @NotNull
    private Set<FilePath> collectPaths(@NotNull List<SvnChangeList> lists) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "collectPaths"));
        }
        Set<FilePath> set = lists.stream().flatMap(list -> list.getAffectedPaths().stream()).map(this::getLocalPath).filter(Objects::nonNull).map(localPath -> VcsUtil.getFilePath((File)localPath, (boolean)false)).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "collectPaths"));
        }
        return set;
    }

    @NotNull
    private static Intersection getAllChangesIntersection(@NotNull List<LocalChangeList> localChangeLists) {
        if (localChangeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localChangeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getAllChangesIntersection"));
        }
        Intersection intersection = LocalChangesPromptTask.getChangesIntersection(localChangeLists, (Condition<Change>)Conditions.alwaysTrue());
        if (intersection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getAllChangesIntersection"));
        }
        return intersection;
    }

    @NotNull
    private static Intersection getChangesIntersection(@NotNull List<LocalChangeList> changeLists, @NotNull Condition<Change> filter) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        Intersection result = new Intersection();
        for (LocalChangeList changeList : changeLists) {
            for (Change change : changeList.getChanges()) {
                if (!filter.value((Object)change)) continue;
                result.add(changeList, change);
            }
        }
        Intersection intersection = result;
        if (intersection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "getChangesIntersection"));
        }
        return intersection;
    }

    private static boolean hasPathToMerge(@NotNull Change change, @NotNull Set<FilePath> pathsToMerge) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "hasPathToMerge"));
        }
        if (pathsToMerge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathsToMerge", "org/jetbrains/idea/svn/integrate/LocalChangesPromptTask", "hasPathToMerge"));
        }
        FilePath beforePath = ChangesUtil.getBeforePath((Change)change);
        FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
        return beforePath != null && pathsToMerge.contains(beforePath) || afterPath != null && pathsToMerge.contains(afterPath);
    }
}

