/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer.colors;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importer.colors.EclipseColorThemeElements;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseThemeReader
extends DefaultHandler
implements EclipseColorThemeElements {
    @Nullable
    private OptionHandler myOptionHandler;
    @Nullable
    private String myThemeName;
    private static final Map<String, Integer> ECLIPSE_DEFAULT_FONT_STYLES = new HashMap();

    public EclipseThemeReader(@Nullable OptionHandler handler) {
        this.myOptionHandler = handler;
    }

    protected void readSettings(InputStream input) throws SchemeImportException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        try {
            SAXParser parser = spf.newSAXParser();
            parser.parse(input, (DefaultHandler)this);
        }
        catch (Exception e) {
            if (e.getCause() instanceof NotAnEclipseThemeException) {
                throw new SchemeImportException("The input file is not a valid Eclipse theme.");
            }
            throw new SchemeImportException((Throwable)e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("colorTheme".equals(qName)) {
            this.myThemeName = attributes.getValue("name");
            if (this.myThemeName == null) {
                throw new SAXException(new NotAnEclipseThemeException("'name' attribute of 'colorTheme' is missing."));
            }
        } else if (this.myThemeName != null) {
            if (this.myOptionHandler != null) {
                this.myOptionHandler.handleColorOption(qName, EclipseThemeReader.readTextAttributes(qName, attributes, EclipseThemeReader.isBackground(qName)));
            }
        } else {
            throw new SAXException(new NotAnEclipseThemeException("'colorTheme' element is missing."));
        }
    }

    private static TextAttributes readTextAttributes(@NotNull String tag, Attributes attributes, boolean isBackground) throws SAXException {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/idea/eclipse/importer/colors/EclipseThemeReader", "readTextAttributes"));
        }
        TextAttributes textAttributes = new TextAttributes();
        Color color = EclipseThemeReader.getColor(attributes);
        if (isBackground) {
            textAttributes.setBackgroundColor(color);
        } else {
            textAttributes.setForegroundColor(color);
        }
        textAttributes.setFontType(EclipseThemeReader.getFontStyle(tag, attributes));
        EffectType effectType = EclipseThemeReader.getEffectType(attributes);
        if (effectType != null) {
            textAttributes.setEffectType(effectType);
            textAttributes.setEffectColor(textAttributes.getForegroundColor());
        }
        return textAttributes;
    }

    private static boolean isBackground(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "org/jetbrains/idea/eclipse/importer/colors/EclipseThemeReader", "isBackground"));
        }
        if (tagName.length() >= "background".length()) {
            tagName = tagName.substring(tagName.length() - "background".length());
            return tagName.equalsIgnoreCase("background");
        }
        return false;
    }

    @Nullable
    public String getThemeName() {
        return this.myThemeName;
    }

    @Nullable
    private static Color getColor(Attributes attributes) throws SAXException {
        String colorString = attributes.getValue("color");
        if (colorString != null && colorString.length() > 0) {
            try {
                int colorValue = Integer.decode(colorString);
                return new Color(colorValue);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Invalid color value: '" + colorString + "'");
            }
        }
        return null;
    }

    @JdkConstants.FontStyle
    private static int getFontStyle(@NotNull String tag, @NotNull Attributes attributes) {
        String italicValue;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/idea/eclipse/importer/colors/EclipseThemeReader", "getFontStyle"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/jetbrains/idea/eclipse/importer/colors/EclipseThemeReader", "getFontStyle"));
        }
        int fontStyle = EclipseThemeReader.getDefaultFontStyle(tag);
        String boldValue = attributes.getValue("bold");
        if (boldValue != null) {
            fontStyle = Boolean.parseBoolean(boldValue) ? (fontStyle |= 1) : (fontStyle &= 0xFFFFFFFE);
        }
        if ((italicValue = attributes.getValue("italic")) != null) {
            fontStyle = Boolean.parseBoolean(italicValue) ? (fontStyle |= 2) : (fontStyle &= 0xFFFFFFFD);
        }
        return fontStyle;
    }

    @JdkConstants.FontStyle
    private static int getDefaultFontStyle(@NotNull String tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/idea/eclipse/importer/colors/EclipseThemeReader", "getDefaultFontStyle"));
        }
        if (ECLIPSE_DEFAULT_FONT_STYLES.containsKey(tag)) {
            return ECLIPSE_DEFAULT_FONT_STYLES.get(tag);
        }
        return 0;
    }

    @Nullable
    private static EffectType getEffectType(@NotNull Attributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "org/jetbrains/idea/eclipse/importer/colors/EclipseThemeReader", "getEffectType"));
        }
        String strikeThrough = attributes.getValue("strikethrough");
        if (strikeThrough != null && Boolean.parseBoolean(strikeThrough)) {
            return EffectType.STRIKEOUT;
        }
        String underline = attributes.getValue("underline");
        if (underline != null && Boolean.parseBoolean(underline)) {
            return EffectType.LINE_UNDERSCORE;
        }
        return null;
    }

    static {
        ECLIPSE_DEFAULT_FONT_STYLES.put("keyword", 1);
    }

    public static interface OptionHandler {
        public void handleColorOption(@NotNull String var1, @NotNull TextAttributes var2);
    }

    private static class NotAnEclipseThemeException
    extends Exception {
        public NotAnEclipseThemeException(String message) {
            super(message);
        }
    }
}

