/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.QueuedWork;
import android.content.SharedPreferences;
import android.os.FileUtils;
import android.os.Looper;
import android.system.ErrnoException;
import android.system.Os;
import android.system.StructStat;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import com.google.android.collect.Maps;
import dalvik.system.BlockGuard;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParserException;

class SharedPreferencesImpl
implements SharedPreferences {
    private static final String TAG = "SharedPreferencesImpl";
    private static final boolean DEBUG = false;
    private final File mFile;
    private final File mBackupFile;
    private final int mMode;
    private Map<String, Object> mMap;
    private int mDiskWritesInFlight = 0;
    private boolean mLoaded = false;
    private long mStatTimestamp;
    private long mStatSize;
    private final Object mWritingToDiskLock = new Object();
    private static final Object mContent = new Object();
    private final WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> mListeners = new WeakHashMap();

    SharedPreferencesImpl(File file, int mode) {
        this.mFile = file;
        this.mBackupFile = SharedPreferencesImpl.makeBackupFile(file);
        this.mMode = mode;
        this.mLoaded = false;
        this.mMap = null;
        this.startLoadFromDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadFromDisk() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.mLoaded = false;
        }
        new Thread("SharedPreferencesImpl-load"){

            @Override
            public void run() {
                SharedPreferencesImpl.this.loadFromDisk();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromDisk() {
        StructStat stat;
        HashMap<String, ?> map;
        block17: {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                if (this.mLoaded) {
                    return;
                }
                if (this.mBackupFile.exists()) {
                    this.mFile.delete();
                    this.mBackupFile.renameTo(this.mFile);
                }
            }
            if (this.mFile.exists() && !this.mFile.canRead()) {
                Log.w(TAG, "Attempt to read preferences file " + this.mFile + " without permission");
            }
            map = null;
            stat = null;
            try {
                stat = Os.stat(this.mFile.getPath());
                if (!this.mFile.canRead()) break block17;
                BufferedInputStream str = null;
                try {
                    str = new BufferedInputStream(new FileInputStream(this.mFile), 16384);
                    map = XmlUtils.readMapXml(str);
                }
                catch (IOException | XmlPullParserException e) {
                    try {
                        Log.w(TAG, "getSharedPreferences", e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(str);
                        throw throwable;
                    }
                    IoUtils.closeQuietly(str);
                    break block17;
                }
                IoUtils.closeQuietly(str);
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
        }
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.mLoaded = true;
            if (map != null) {
                this.mMap = map;
                this.mStatTimestamp = stat.st_mtime;
                this.mStatSize = stat.st_size;
            } else {
                this.mMap = new HashMap<String, Object>();
            }
            this.notifyAll();
        }
    }

    static File makeBackupFile(File prefsFile) {
        return new File(prefsFile.getPath() + ".bak");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startReloadIfChangedUnexpectedly() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            if (!this.hasFileChangedUnexpectedly()) {
                return;
            }
            this.startLoadFromDisk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFileChangedUnexpectedly() {
        StructStat stat;
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            if (this.mDiskWritesInFlight > 0) {
                return false;
            }
        }
        try {
            BlockGuard.getThreadPolicy().onReadFromDisk();
            stat = Os.stat(this.mFile.getPath());
        }
        catch (ErrnoException e) {
            return true;
        }
        SharedPreferencesImpl sharedPreferencesImpl2 = this;
        synchronized (sharedPreferencesImpl2) {
            return this.mStatTimestamp != stat.st_mtime || this.mStatSize != stat.st_size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.mListeners.put(listener, mContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.mListeners.remove(listener);
        }
    }

    private void awaitLoadedLocked() {
        if (!this.mLoaded) {
            BlockGuard.getThreadPolicy().onReadFromDisk();
        }
        while (!this.mLoaded) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> getAll() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            return new HashMap<String, Object>(this.mMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String key, String defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            String v = (String)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getStringSet(String key, Set<String> defValues) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            Set<String> v = (Set<String>)this.mMap.get(key);
            return v != null ? v : defValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String key, int defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            Integer v = (Integer)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String key, long defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            Long v = (Long)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String key, float defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            Float v = (Float)this.mMap.get(key);
            return v != null ? v.floatValue() : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String key, boolean defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            Boolean v = (Boolean)this.mMap.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String key) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
            return this.mMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SharedPreferences.Editor edit() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.awaitLoadedLocked();
        }
        return new EditorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueDiskWrite(final MemoryCommitResult mcr, final Runnable postWriteRunnable) {
        boolean isFromSyncCommit;
        Runnable writeToDiskRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SharedPreferencesImpl.this.mWritingToDiskLock;
                synchronized (object) {
                    SharedPreferencesImpl.this.writeToFile(mcr);
                }
                object = SharedPreferencesImpl.this;
                synchronized (object) {
                    SharedPreferencesImpl.this.mDiskWritesInFlight--;
                }
                if (postWriteRunnable != null) {
                    postWriteRunnable.run();
                }
            }
        };
        boolean bl = isFromSyncCommit = postWriteRunnable == null;
        if (isFromSyncCommit) {
            boolean wasEmpty = false;
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                wasEmpty = this.mDiskWritesInFlight == 1;
            }
            if (wasEmpty) {
                writeToDiskRunnable.run();
                return;
            }
        }
        QueuedWork.singleThreadExecutor().execute(writeToDiskRunnable);
    }

    private static FileOutputStream createFileOutputStream(File file) {
        FileOutputStream str = null;
        try {
            str = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            File parent = file.getParentFile();
            if (!parent.mkdir()) {
                Log.e(TAG, "Couldn't create directory for SharedPreferences file " + file);
                return null;
            }
            FileUtils.setPermissions(parent.getPath(), 505, -1, -1);
            try {
                str = new FileOutputStream(file);
            }
            catch (FileNotFoundException e2) {
                Log.e(TAG, "Couldn't create SharedPreferences file " + file, e2);
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(MemoryCommitResult mcr) {
        if (this.mFile.exists()) {
            if (!mcr.changesMade) {
                mcr.setDiskWriteResult(true);
                return;
            }
            if (!this.mBackupFile.exists()) {
                if (!this.mFile.renameTo(this.mBackupFile)) {
                    Log.e(TAG, "Couldn't rename file " + this.mFile + " to backup file " + this.mBackupFile);
                    mcr.setDiskWriteResult(false);
                    return;
                }
            } else {
                this.mFile.delete();
            }
        }
        try {
            FileOutputStream str = SharedPreferencesImpl.createFileOutputStream(this.mFile);
            if (str == null) {
                mcr.setDiskWriteResult(false);
                return;
            }
            XmlUtils.writeMapXml(mcr.mapToWriteToDisk, str);
            FileUtils.sync(str);
            str.close();
            ContextImpl.setFilePermissionsFromMode(this.mFile.getPath(), this.mMode, 0);
            try {
                StructStat stat = Os.stat(this.mFile.getPath());
                SharedPreferencesImpl sharedPreferencesImpl = this;
                synchronized (sharedPreferencesImpl) {
                    this.mStatTimestamp = stat.st_mtime;
                    this.mStatSize = stat.st_size;
                }
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
            this.mBackupFile.delete();
            mcr.setDiskWriteResult(true);
            return;
        }
        catch (XmlPullParserException e) {
            Log.w(TAG, "writeToFile: Got exception:", e);
        }
        catch (IOException e) {
            Log.w(TAG, "writeToFile: Got exception:", e);
        }
        if (this.mFile.exists() && !this.mFile.delete()) {
            Log.e(TAG, "Couldn't clean up partially-written file " + this.mFile);
        }
        mcr.setDiskWriteResult(false);
    }

    public class EditorImpl
    implements SharedPreferences.Editor {
        private final Map<String, Object> mModified = Maps.newHashMap();
        private boolean mClear = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putString(String key, String value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, values == null ? null : new HashSet<String>(values));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putInt(String key, int value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putLong(String key, long value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putFloat(String key, float value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, Float.valueOf(value));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor remove(String key) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.put(key, this);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedPreferences.Editor clear() {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mClear = true;
                return this;
            }
        }

        @Override
        public void apply() {
            final MemoryCommitResult mcr = this.commitToMemory();
            final Runnable awaitCommit = new Runnable(){

                @Override
                public void run() {
                    try {
                        mcr.writtenToDiskLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            QueuedWork.add(awaitCommit);
            Runnable postWriteRunnable = new Runnable(){

                @Override
                public void run() {
                    awaitCommit.run();
                    QueuedWork.remove(awaitCommit);
                }
            };
            SharedPreferencesImpl.this.enqueueDiskWrite(mcr, postWriteRunnable);
            this.notifyListeners(mcr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MemoryCommitResult commitToMemory() {
            MemoryCommitResult mcr = new MemoryCommitResult();
            SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
            synchronized (sharedPreferencesImpl) {
                boolean hasListeners;
                if (SharedPreferencesImpl.this.mDiskWritesInFlight > 0) {
                    SharedPreferencesImpl.this.mMap = new HashMap(SharedPreferencesImpl.this.mMap);
                }
                mcr.mapToWriteToDisk = SharedPreferencesImpl.this.mMap;
                SharedPreferencesImpl.this.mDiskWritesInFlight++;
                boolean bl = hasListeners = SharedPreferencesImpl.this.mListeners.size() > 0;
                if (hasListeners) {
                    mcr.keysModified = new ArrayList<String>();
                    mcr.listeners = new HashSet(SharedPreferencesImpl.this.mListeners.keySet());
                }
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    if (this.mClear) {
                        if (!SharedPreferencesImpl.this.mMap.isEmpty()) {
                            mcr.changesMade = true;
                            SharedPreferencesImpl.this.mMap.clear();
                        }
                        this.mClear = false;
                    }
                    for (Map.Entry<String, Object> e : this.mModified.entrySet()) {
                        String k = e.getKey();
                        Object v = e.getValue();
                        if (v == this || v == null) {
                            if (!SharedPreferencesImpl.this.mMap.containsKey(k)) continue;
                            SharedPreferencesImpl.this.mMap.remove(k);
                        } else {
                            Object existingValue;
                            if (SharedPreferencesImpl.this.mMap.containsKey(k) && (existingValue = SharedPreferencesImpl.this.mMap.get(k)) != null && existingValue.equals(v)) continue;
                            SharedPreferencesImpl.this.mMap.put(k, v);
                        }
                        mcr.changesMade = true;
                        if (!hasListeners) continue;
                        mcr.keysModified.add(k);
                    }
                    this.mModified.clear();
                }
            }
            return mcr;
        }

        @Override
        public boolean commit() {
            MemoryCommitResult mcr = this.commitToMemory();
            SharedPreferencesImpl.this.enqueueDiskWrite(mcr, null);
            try {
                mcr.writtenToDiskLatch.await();
            }
            catch (InterruptedException e) {
                return false;
            }
            this.notifyListeners(mcr);
            return mcr.writeToDiskResult;
        }

        private void notifyListeners(final MemoryCommitResult mcr) {
            if (mcr.listeners == null || mcr.keysModified == null || mcr.keysModified.size() == 0) {
                return;
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                for (int i = mcr.keysModified.size() - 1; i >= 0; --i) {
                    String key = mcr.keysModified.get(i);
                    for (SharedPreferences.OnSharedPreferenceChangeListener listener : mcr.listeners) {
                        if (listener == null) continue;
                        listener.onSharedPreferenceChanged(SharedPreferencesImpl.this, key);
                    }
                }
            } else {
                ActivityThread.sMainThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        EditorImpl.this.notifyListeners(mcr);
                    }
                });
            }
        }
    }

    private static class MemoryCommitResult {
        public boolean changesMade;
        public List<String> keysModified;
        public Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
        public Map<?, ?> mapToWriteToDisk;
        public final CountDownLatch writtenToDiskLatch = new CountDownLatch(1);
        public volatile boolean writeToDiskResult = false;

        private MemoryCommitResult() {
        }

        public void setDiskWriteResult(boolean result) {
            this.writeToDiskResult = result;
            this.writtenToDiskLatch.countDown();
        }
    }
}

