/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Printer;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;

public class SQLiteDebug {
    public static final boolean DEBUG_SQL_LOG = Log.isLoggable("SQLiteLog", 2);
    public static final boolean DEBUG_SQL_STATEMENTS = Log.isLoggable("SQLiteStatements", 2);
    public static final boolean DEBUG_SQL_TIME = Log.isLoggable("SQLiteTime", 2);
    public static final boolean DEBUG_LOG_SLOW_QUERIES = Build.IS_DEBUGGABLE;

    private static void nativeGetPagerStats(PagerStats pagerStats) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDebug#nativeGetPagerStats(Landroid/database/sqlite/SQLiteDebug$PagerStats;)V", true, null);
    }

    private SQLiteDebug() {
    }

    public static boolean shouldLogSlowQuery(long elapsedTimeMillis) {
        int slowQueryMillis = SystemProperties.getInt("db.log.slow_query_threshold", -1);
        return slowQueryMillis >= 0 && elapsedTimeMillis >= (long)slowQueryMillis;
    }

    public static PagerStats getDatabaseInfo() {
        PagerStats stats = new PagerStats();
        SQLiteDebug.nativeGetPagerStats(stats);
        stats.dbStats = SQLiteDatabase.getDbStats();
        return stats;
    }

    public static void dump(Printer printer, String[] args) {
        boolean verbose = false;
        for (String arg : args) {
            if (!arg.equals("-v")) continue;
            verbose = true;
        }
        SQLiteDatabase.dumpAll(printer, verbose);
    }

    public static class DbStats {
        public String dbName;
        public long pageSize;
        public long dbSize;
        public int lookaside;
        public String cache;

        public DbStats(String dbName, long pageCount, long pageSize, int lookaside, int hits, int misses, int cachesize) {
            this.dbName = dbName;
            this.pageSize = pageSize / 1024L;
            this.dbSize = pageCount * pageSize / 1024L;
            this.lookaside = lookaside;
            this.cache = hits + "/" + misses + "/" + cachesize;
        }
    }

    public static class PagerStats {
        public int memoryUsed;
        public int pageCacheOverflow;
        public int largestMemAlloc;
        public ArrayList<DbStats> dbStats;
    }
}

