/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.FontFamily;
import android.graphics.FontFamily_Delegate;
import android.graphics.FontListParser;
import android.graphics.Typeface;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Font;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class Typeface_Delegate {
    public static final String SYSTEM_FONTS = "/system/fonts/";
    private static final DelegateManager<Typeface_Delegate> sManager = new DelegateManager<Typeface_Delegate>(Typeface_Delegate.class);
    private final FontFamily_Delegate[] mFontFamilies;
    private final int mStyle;
    private final int mWeight;
    private static long sDefaultTypeface;

    public static Typeface_Delegate getDelegate(long nativeTypeface) {
        return sManager.getDelegate(nativeTypeface);
    }

    public List<Font> getFonts(FontFamily_Delegate.FontVariant variant) {
        assert (variant != FontFamily_Delegate.FontVariant.NONE);
        int weight = this.mWeight + ((this.mStyle & 1) == 0 ? 0 : 300);
        if (weight > 900) {
            weight = 900;
        }
        boolean isItalic = (this.mStyle & 2) != 0;
        ArrayList<Font> fonts = new ArrayList<Font>(this.mFontFamilies.length);
        for (int i = 0; i < this.mFontFamilies.length; ++i) {
            FontFamily_Delegate ffd = this.mFontFamilies[i];
            if (ffd == null || !ffd.isValid()) continue;
            Font font = ffd.getFont(weight, isItalic);
            if (font != null) {
                FontFamily_Delegate.FontVariant ffdVariant = ffd.getVariant();
                if (ffdVariant == FontFamily_Delegate.FontVariant.NONE) {
                    fonts.add(font);
                    continue;
                }
                assert (i < this.mFontFamilies.length - 1);
                FontFamily_Delegate ffd2 = this.mFontFamilies[++i];
                assert (ffd2 != null);
                FontFamily_Delegate.FontVariant ffd2Variant = ffd2.getVariant();
                Font font2 = ffd2.getFont(weight, isItalic);
                assert (ffd2Variant != FontFamily_Delegate.FontVariant.NONE && ffd2Variant != ffdVariant && font2 != null);
                if (variant == ffd.getVariant()) {
                    fonts.add(font);
                    continue;
                }
                fonts.add(font2);
                continue;
            }
            fonts.add(null);
        }
        return fonts;
    }

    public static void resetDefaults() {
        if (FontFamily_Delegate.getFontLocation() != null) {
            Typeface.sDefaults = null;
        }
    }

    @LayoutlibDelegate
    static synchronized long nativeCreateFromTypeface(long native_instance, int style2) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            delegate = sManager.getDelegate(sDefaultTypeface);
        }
        if (delegate == null) {
            return 0L;
        }
        return sManager.addNewDelegate(new Typeface_Delegate(delegate.mFontFamilies, style2, delegate.mWeight));
    }

    @LayoutlibDelegate
    static long nativeCreateWeightAlias(long native_instance, int weight) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            delegate = sManager.getDelegate(sDefaultTypeface);
        }
        if (delegate == null) {
            return 0L;
        }
        Typeface_Delegate weightAlias = new Typeface_Delegate(delegate.mFontFamilies, delegate.mStyle, weight);
        return sManager.addNewDelegate(weightAlias);
    }

    @LayoutlibDelegate
    static synchronized long nativeCreateFromArray(long[] familyArray) {
        FontFamily_Delegate[] fontFamilies = new FontFamily_Delegate[familyArray.length];
        for (int i = 0; i < familyArray.length; ++i) {
            fontFamilies[i] = FontFamily_Delegate.getDelegate(familyArray[i]);
        }
        Typeface_Delegate delegate = new Typeface_Delegate(fontFamilies, 0);
        return sManager.addNewDelegate(delegate);
    }

    @LayoutlibDelegate
    static void nativeUnref(long native_instance) {
        sManager.removeJavaReferenceFor(native_instance);
    }

    @LayoutlibDelegate
    static int nativeGetStyle(long native_instance) {
        Typeface_Delegate delegate = sManager.getDelegate(native_instance);
        if (delegate == null) {
            return 0;
        }
        return delegate.mStyle;
    }

    @LayoutlibDelegate
    static void nativeSetDefault(long native_instance) {
        sDefaultTypeface = native_instance;
    }

    @LayoutlibDelegate
    static File getSystemFontConfigLocation() {
        return new File(FontFamily_Delegate.getFontLocation());
    }

    @LayoutlibDelegate
    static FontFamily makeFamilyFromParsed(FontListParser.Family family, Map<String, ByteBuffer> bufferForPath) {
        FontFamily fontFamily = new FontFamily(family.lang, family.variant);
        for (FontListParser.Font font : family.fonts) {
            FontFamily_Delegate.addFont(fontFamily.mNativePtr, font.fontName, font.weight, font.isItalic);
        }
        return fontFamily;
    }

    private Typeface_Delegate(FontFamily_Delegate[] fontFamilies, int style2) {
        this(fontFamilies, style2, 400);
    }

    public Typeface_Delegate(FontFamily_Delegate[] fontFamilies, int style2, int weight) {
        this.mFontFamilies = fontFamilies;
        this.mStyle = style2;
        this.mWeight = weight;
    }
}

