/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.os.Environment;
import android.os.UserHandle;
import android.security.net.config.DirectoryCertificateSource;
import java.io.File;

public class SystemCertificateSource
extends DirectoryCertificateSource {
    private final File mUserRemovedCaDir;

    private SystemCertificateSource() {
        super(new File(System.getenv("ANDROID_ROOT") + "/etc/security/cacerts"));
        File configDir = Environment.getUserConfigDirectory(UserHandle.myUserId());
        this.mUserRemovedCaDir = new File(configDir, "cacerts-removed");
    }

    public static SystemCertificateSource getInstance() {
        return NoPreloadHolder.INSTANCE;
    }

    @Override
    protected boolean isCertMarkedAsRemoved(String caFile) {
        return new File(this.mUserRemovedCaDir, caFile).exists();
    }

    private static class NoPreloadHolder {
        private static final SystemCertificateSource INSTANCE = new SystemCertificateSource();

        private NoPreloadHolder() {
        }
    }
}

