/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.textservice.ITextServicesManager;
import java.util.Locale;

public class TextServicesManager {
    private static final String TAG = TextServicesManager.class.getSimpleName();
    private static final boolean DBG = false;
    private static TextServicesManager sInstance;
    private static ITextServicesManager sService;

    private TextServicesManager() {
        if (sService == null) {
            IBinder b = ServiceManager.getService("textservices");
            sService = ITextServicesManager.Stub.asInterface(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextServicesManager getInstance() {
        Class<TextServicesManager> clazz = TextServicesManager.class;
        synchronized (TextServicesManager.class) {
            if (sInstance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
            sInstance = new TextServicesManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private static String parseLanguageFromLocaleString(String locale) {
        int idx = locale.indexOf(95);
        if (idx < 0) {
            return locale;
        }
        return locale.substring(0, idx);
    }

    public SpellCheckerSession newSpellCheckerSession(Bundle bundle, Locale locale, SpellCheckerSession.SpellCheckerSessionListener listener, boolean referToSpellCheckerLanguageSettings) {
        SpellCheckerInfo sci;
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!referToSpellCheckerLanguageSettings && locale == null) {
            throw new IllegalArgumentException("Locale should not be null if you don't refer settings.");
        }
        if (referToSpellCheckerLanguageSettings && !this.isSpellCheckerEnabled()) {
            return null;
        }
        try {
            sci = sService.getCurrentSpellChecker(null);
        }
        catch (RemoteException e) {
            return null;
        }
        if (sci == null) {
            return null;
        }
        SpellCheckerSubtype subtypeInUse = null;
        if (referToSpellCheckerLanguageSettings) {
            String subtypeLocale;
            String subtypeLanguage;
            subtypeInUse = this.getCurrentSpellCheckerSubtype(true);
            if (subtypeInUse == null) {
                return null;
            }
            if (!(locale == null || (subtypeLanguage = TextServicesManager.parseLanguageFromLocaleString(subtypeLocale = subtypeInUse.getLocale())).length() >= 2 && locale.getLanguage().equals(subtypeLanguage))) {
                return null;
            }
        } else {
            String localeStr = locale.toString();
            for (int i = 0; i < sci.getSubtypeCount(); ++i) {
                SpellCheckerSubtype subtype = sci.getSubtypeAt(i);
                String tempSubtypeLocale = subtype.getLocale();
                String tempSubtypeLanguage = TextServicesManager.parseLanguageFromLocaleString(tempSubtypeLocale);
                if (tempSubtypeLocale.equals(localeStr)) {
                    subtypeInUse = subtype;
                    break;
                }
                if (tempSubtypeLanguage.length() < 2 || !locale.getLanguage().equals(tempSubtypeLanguage)) continue;
                subtypeInUse = subtype;
            }
        }
        if (subtypeInUse == null) {
            return null;
        }
        SpellCheckerSession session = new SpellCheckerSession(sci, sService, listener, subtypeInUse);
        try {
            sService.getSpellCheckerService(sci.getId(), subtypeInUse.getLocale(), session.getTextServicesSessionListener(), session.getSpellCheckerSessionListener(), bundle);
        }
        catch (RemoteException e) {
            return null;
        }
        return session;
    }

    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        try {
            SpellCheckerInfo[] retval = sService.getEnabledSpellCheckers();
            return retval;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in getEnabledSpellCheckers: " + e);
            return null;
        }
    }

    public SpellCheckerInfo getCurrentSpellChecker() {
        try {
            return sService.getCurrentSpellChecker(null);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public void setCurrentSpellChecker(SpellCheckerInfo sci) {
        try {
            if (sci == null) {
                throw new NullPointerException("SpellCheckerInfo is null.");
            }
            sService.setCurrentSpellChecker(null, sci.getId());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in setCurrentSpellChecker: " + e);
        }
    }

    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(boolean allowImplicitlySelectedSubtype) {
        try {
            if (sService == null) {
                Log.e(TAG, "sService is null.");
                return null;
            }
            return sService.getCurrentSpellCheckerSubtype(null, allowImplicitlySelectedSubtype);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in getCurrentSpellCheckerSubtype: " + e);
            return null;
        }
    }

    public void setSpellCheckerSubtype(SpellCheckerSubtype subtype) {
        try {
            int hashCode = subtype == null ? 0 : subtype.hashCode();
            sService.setCurrentSpellCheckerSubtype(null, hashCode);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in setSpellCheckerSubtype:" + e);
        }
    }

    public void setSpellCheckerEnabled(boolean enabled) {
        try {
            sService.setSpellCheckerEnabled(enabled);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in setSpellCheckerEnabled:" + e);
        }
    }

    public boolean isSpellCheckerEnabled() {
        try {
            return sService.isSpellCheckerEnabled();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in isSpellCheckerEnabled:" + e);
            return false;
        }
    }
}

