/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.ThreadedRenderer;
import com.android.internal.policy.DecorView;

public class BackdropFrameRenderer
extends Thread
implements Choreographer.FrameCallback {
    private DecorView mDecorView;
    private final Rect mTargetRect = new Rect();
    private ThreadedRenderer mRenderer;
    private RenderNode mFrameAndBackdropNode;
    private RenderNode mSystemBarBackgroundNode;
    private final Rect mOldTargetRect = new Rect();
    private final Rect mNewTargetRect = new Rect();
    private Choreographer mChoreographer;
    private int mLastContentWidth;
    private int mLastContentHeight;
    private int mLastCaptionHeight;
    private int mLastXOffset;
    private int mLastYOffset;
    private boolean mReportNextDraw;
    private Drawable mCaptionBackgroundDrawable;
    private Drawable mUserCaptionBackgroundDrawable;
    private Drawable mResizingBackgroundDrawable;
    private ColorDrawable mStatusBarColor;
    private ColorDrawable mNavigationBarColor;
    private boolean mOldFullscreen;
    private boolean mFullscreen;
    private final int mResizeMode;
    private final Rect mOldSystemInsets = new Rect();
    private final Rect mOldStableInsets = new Rect();
    private final Rect mSystemInsets = new Rect();
    private final Rect mStableInsets = new Rect();

    public BackdropFrameRenderer(DecorView decorView, ThreadedRenderer renderer, Rect initialBounds, Drawable resizingBackgroundDrawable, Drawable captionBackgroundDrawable, Drawable userCaptionBackgroundDrawable, int statusBarColor, int navigationBarColor, boolean fullscreen, Rect systemInsets, Rect stableInsets, int resizeMode) {
        this.setName("ResizeFrame");
        this.mRenderer = renderer;
        this.onResourcesLoaded(decorView, resizingBackgroundDrawable, captionBackgroundDrawable, userCaptionBackgroundDrawable, statusBarColor, navigationBarColor);
        this.mFrameAndBackdropNode = RenderNode.create("FrameAndBackdropNode", null);
        this.mRenderer.addRenderNode(this.mFrameAndBackdropNode, true);
        this.mTargetRect.set(initialBounds);
        this.mFullscreen = fullscreen;
        this.mOldFullscreen = fullscreen;
        this.mSystemInsets.set(systemInsets);
        this.mStableInsets.set(stableInsets);
        this.mOldSystemInsets.set(systemInsets);
        this.mOldStableInsets.set(stableInsets);
        this.mResizeMode = resizeMode;
        this.start();
    }

    void onResourcesLoaded(DecorView decorView, Drawable resizingBackgroundDrawable, Drawable captionBackgroundDrawableDrawable, Drawable userCaptionBackgroundDrawable, int statusBarColor, int navigationBarColor) {
        this.mDecorView = decorView;
        this.mResizingBackgroundDrawable = resizingBackgroundDrawable != null ? resizingBackgroundDrawable.getConstantState().newDrawable() : null;
        this.mCaptionBackgroundDrawable = captionBackgroundDrawableDrawable != null ? captionBackgroundDrawableDrawable.getConstantState().newDrawable() : null;
        Drawable drawable2 = this.mUserCaptionBackgroundDrawable = userCaptionBackgroundDrawable != null ? userCaptionBackgroundDrawable.getConstantState().newDrawable() : null;
        if (this.mCaptionBackgroundDrawable == null) {
            this.mCaptionBackgroundDrawable = this.mResizingBackgroundDrawable;
        }
        if (statusBarColor != 0) {
            this.mStatusBarColor = new ColorDrawable(statusBarColor);
            this.addSystemBarNodeIfNeeded();
        } else {
            this.mStatusBarColor = null;
        }
        if (navigationBarColor != 0) {
            this.mNavigationBarColor = new ColorDrawable(navigationBarColor);
            this.addSystemBarNodeIfNeeded();
        } else {
            this.mNavigationBarColor = null;
        }
    }

    private void addSystemBarNodeIfNeeded() {
        if (this.mSystemBarBackgroundNode != null) {
            return;
        }
        this.mSystemBarBackgroundNode = RenderNode.create("SystemBarBackgroundNode", null);
        this.mRenderer.addRenderNode(this.mSystemBarBackgroundNode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetRect(Rect newTargetBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            this.mFullscreen = fullscreen;
            this.mTargetRect.set(newTargetBounds);
            this.mSystemInsets.set(systemInsets);
            this.mStableInsets.set(stableInsets);
            this.pingRenderLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationChange() {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            if (this.mRenderer != null) {
                this.mOldTargetRect.set(0, 0, 0, 0);
                this.pingRenderLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRenderer() {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            if (this.mRenderer != null) {
                this.mRenderer.setContentDrawBounds(0, 0, 0, 0);
                this.mRenderer.removeRenderNode(this.mFrameAndBackdropNode);
                if (this.mSystemBarBackgroundNode != null) {
                    this.mRenderer.removeRenderNode(this.mSystemBarBackgroundNode);
                }
                this.mRenderer = null;
                this.pingRenderLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BackdropFrameRenderer backdropFrameRenderer;
        try {
            Looper.prepare();
            backdropFrameRenderer = this;
            synchronized (backdropFrameRenderer) {
                this.mChoreographer = Choreographer.getInstance();
            }
            Looper.loop();
        }
        finally {
            this.releaseRenderer();
        }
        backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            this.mChoreographer = null;
            Choreographer.releaseInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFrame(long frameTimeNanos) {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            if (this.mRenderer == null) {
                this.reportDrawIfNeeded();
                Looper.myLooper().quit();
                return;
            }
            this.doFrameUncheckedLocked();
        }
    }

    private void doFrameUncheckedLocked() {
        this.mNewTargetRect.set(this.mTargetRect);
        if (!this.mNewTargetRect.equals(this.mOldTargetRect) || this.mOldFullscreen != this.mFullscreen || !this.mStableInsets.equals(this.mOldStableInsets) || !this.mSystemInsets.equals(this.mOldSystemInsets) || this.mReportNextDraw) {
            this.mOldFullscreen = this.mFullscreen;
            this.mOldTargetRect.set(this.mNewTargetRect);
            this.mOldSystemInsets.set(this.mSystemInsets);
            this.mOldStableInsets.set(this.mStableInsets);
            this.redrawLocked(this.mNewTargetRect, this.mFullscreen, this.mSystemInsets, this.mStableInsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onContentDrawn(int xOffset, int yOffset, int xSize, int ySize) {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            boolean firstCall = this.mLastContentWidth == 0;
            this.mLastContentWidth = xSize;
            this.mLastContentHeight = ySize - this.mLastCaptionHeight;
            this.mLastXOffset = xOffset;
            this.mLastYOffset = yOffset;
            this.mRenderer.setContentDrawBounds(this.mLastXOffset, this.mLastYOffset, this.mLastXOffset + this.mLastContentWidth, this.mLastYOffset + this.mLastCaptionHeight + this.mLastContentHeight);
            return firstCall && (this.mLastCaptionHeight != 0 || !this.mDecorView.isShowingCaption());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestDraw(boolean reportNextDraw) {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            this.mReportNextDraw = reportNextDraw;
            this.mOldTargetRect.set(0, 0, 0, 0);
            this.pingRenderLocked(true);
        }
    }

    private void redrawLocked(Rect newBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        Drawable drawable2;
        int captionHeight = this.mDecorView.getCaptionHeight();
        if (captionHeight != 0) {
            this.mLastCaptionHeight = captionHeight;
        }
        if (this.mLastCaptionHeight == 0 && this.mDecorView.isShowingCaption() || this.mLastContentWidth == 0 || this.mLastContentHeight == 0) {
            return;
        }
        int left = this.mLastXOffset + newBounds.left;
        int top = this.mLastYOffset + newBounds.top;
        int width = newBounds.width();
        int height = newBounds.height();
        this.mFrameAndBackdropNode.setLeftTopRightBottom(left, top, left + width, top + height);
        DisplayListCanvas canvas = this.mFrameAndBackdropNode.start(width, height);
        Drawable drawable3 = drawable2 = this.mUserCaptionBackgroundDrawable != null ? this.mUserCaptionBackgroundDrawable : this.mCaptionBackgroundDrawable;
        if (drawable2 != null) {
            drawable2.setBounds(0, 0, left + width, top + this.mLastCaptionHeight);
            drawable2.draw(canvas);
        }
        if (this.mResizingBackgroundDrawable != null) {
            this.mResizingBackgroundDrawable.setBounds(0, this.mLastCaptionHeight, left + width, top + height);
            this.mResizingBackgroundDrawable.draw(canvas);
        }
        this.mFrameAndBackdropNode.end(canvas);
        this.drawColorViews(left, top, width, height, fullscreen, systemInsets, stableInsets);
        this.mRenderer.drawRenderNode(this.mFrameAndBackdropNode);
        this.reportDrawIfNeeded();
    }

    private void drawColorViews(int left, int top, int width, int height, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        if (this.mSystemBarBackgroundNode == null) {
            return;
        }
        DisplayListCanvas canvas = this.mSystemBarBackgroundNode.start(width, height);
        this.mSystemBarBackgroundNode.setLeftTopRightBottom(left, top, left + width, top + height);
        int topInset = DecorView.getColorViewTopInset(this.mStableInsets.top, this.mSystemInsets.top);
        int bottomInset = DecorView.getColorViewBottomInset(stableInsets.bottom, systemInsets.bottom);
        int rightInset = DecorView.getColorViewRightInset(stableInsets.right, systemInsets.right);
        if (this.mStatusBarColor != null) {
            this.mStatusBarColor.setBounds(0, 0, left + width, topInset);
            this.mStatusBarColor.draw(canvas);
        }
        if (this.mNavigationBarColor != null && fullscreen) {
            int size = DecorView.getNavBarSize(bottomInset, rightInset);
            if (DecorView.isNavBarToRightEdge(bottomInset, rightInset)) {
                this.mNavigationBarColor.setBounds(width - size, 0, width, height);
            } else {
                this.mNavigationBarColor.setBounds(0, height - size, width, height);
            }
            this.mNavigationBarColor.draw(canvas);
        }
        this.mSystemBarBackgroundNode.end(canvas);
        this.mRenderer.drawRenderNode(this.mSystemBarBackgroundNode);
    }

    private void reportDrawIfNeeded() {
        if (this.mReportNextDraw) {
            if (this.mDecorView.isAttachedToWindow()) {
                this.mDecorView.getViewRootImpl().reportDrawFinish();
            }
            this.mReportNextDraw = false;
        }
    }

    private void pingRenderLocked(boolean drawImmediate) {
        if (this.mChoreographer != null && !drawImmediate) {
            this.mChoreographer.postFrameCallback(this);
        } else {
            this.doFrameUncheckedLocked();
        }
    }

    void setUserCaptionBackgroundDrawable(Drawable userCaptionBackgroundDrawable) {
        this.mUserCaptionBackgroundDrawable = userCaptionBackgroundDrawable;
    }
}

