/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.bars.AppCompatActionBar;
import com.android.layoutlib.bridge.bars.BridgeActionBar;
import com.android.layoutlib.bridge.bars.Config;
import com.android.layoutlib.bridge.bars.FrameworkActionBar;
import com.android.layoutlib.bridge.bars.NavigationBar;
import com.android.layoutlib.bridge.bars.StatusBar;
import com.android.layoutlib.bridge.bars.TitleBar;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;

class Layout
extends RelativeLayout {
    private static final String ATTR_WINDOW_FLOATING = "windowIsFloating";
    private static final String ATTR_WINDOW_BACKGROUND = "windowBackground";
    private static final String ATTR_WINDOW_FULL_SCREEN = "windowFullscreen";
    private static final String ATTR_NAV_BAR_HEIGHT = "navigation_bar_height";
    private static final String ATTR_NAV_BAR_WIDTH = "navigation_bar_width";
    private static final String ATTR_STATUS_BAR_HEIGHT = "status_bar_height";
    private static final String ATTR_WINDOW_ACTION_BAR = "windowActionBar";
    private static final String ATTR_ACTION_BAR_SIZE = "actionBarSize";
    private static final String ATTR_WINDOW_NO_TITLE = "windowNoTitle";
    private static final String ATTR_WINDOW_TITLE_SIZE = "windowTitleSize";
    private static final String ATTR_WINDOW_TRANSLUCENT_STATUS = "windowTranslucentStatus";
    private static final String ATTR_WINDOW_TRANSLUCENT_NAV = "windowTranslucentNavigation";
    private static final int DEFAULT_STATUS_BAR_HEIGHT = 25;
    private static final int DEFAULT_TITLE_BAR_HEIGHT = 25;
    private static final int DEFAULT_NAV_BAR_SIZE = 48;
    private static final String ID_NAV_BAR = "navBar";
    private static final String ID_STATUS_BAR = "statusBar";
    private static final String ID_TITLE_BAR = "titleBar";
    private static final String ID_PREFIX = "android_layoutlib_";
    private Builder mBuilder;
    private FrameLayout mContentRoot;

    public Layout(Builder builder) {
        super(builder.mContext);
        View view;
        this.mBuilder = builder;
        if (builder.mWindowBackground != null) {
            Drawable d = ResourceHelper.getDrawable(builder.mWindowBackground, builder.mContext);
            this.setBackground(d);
        }
        int simulatedPlatformVersion = this.getParams().getSimulatedPlatformVersion();
        HardwareConfig hwConfig = this.getParams().getHardwareConfig();
        Density density = hwConfig.getDensity();
        boolean isRtl = Bridge.isLocaleRtl(this.getParams().getLocale());
        this.setLayoutDirection(isRtl ? 1 : 0);
        NavigationBar navBar = null;
        if (this.mBuilder.hasNavBar()) {
            navBar = this.createNavBar(this.getContext(), density, isRtl, this.getParams().isRtlSupported(), simulatedPlatformVersion);
        }
        StatusBar statusBar = null;
        if (builder.mStatusBarSize > 0) {
            statusBar = this.createStatusBar(this.getContext(), density, isRtl, this.getParams().isRtlSupported(), simulatedPlatformVersion);
        }
        View actionBar = null;
        TitleBar titleBar = null;
        if (builder.mActionBarSize > 0) {
            BridgeActionBar bar = this.createActionBar(this.getContext(), this.getParams());
            this.mContentRoot = bar.getContentRoot();
            actionBar = bar.getRootView();
        } else if (this.mBuilder.mTitleBarSize > 0) {
            titleBar = this.createTitleBar(this.getContext(), this.getParams().getAppLabel(), simulatedPlatformVersion);
        }
        View[] viewArray = new View[4];
        viewArray[0] = titleBar;
        if (this.mContentRoot == null) {
            this.mContentRoot = this.createContentFrame();
            view = this.mContentRoot;
        } else {
            view = actionBar;
        }
        viewArray[1] = view;
        viewArray[2] = statusBar;
        viewArray[3] = navBar;
        this.addViews(viewArray);
        this.mBuilder = null;
    }

    private FrameLayout createContentFrame() {
        int rule;
        FrameLayout contentRoot = new FrameLayout(this.getContext());
        RelativeLayout.LayoutParams params = this.createLayoutParams(-1, -1);
        int n = rule = this.mBuilder.isNavBarVertical() ? 16 : 2;
        if (this.mBuilder.hasNavBar() && this.mBuilder.solidBars()) {
            params.addRule(rule, this.getId(ID_NAV_BAR));
        }
        int below = -1;
        if (this.mBuilder.mActionBarSize <= 0 && this.mBuilder.mTitleBarSize > 0) {
            below = this.getId(ID_TITLE_BAR);
        } else if (this.mBuilder.hasStatusBar() && this.mBuilder.solidBars()) {
            below = this.getId(ID_STATUS_BAR);
        }
        if (below != -1) {
            params.addRule(3, below);
        }
        contentRoot.setLayoutParams(params);
        return contentRoot;
    }

    private RelativeLayout.LayoutParams createLayoutParams(int width, int height) {
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        if (width > 0) {
            width = (int)TypedValue.applyDimension(1, width, metrics);
        }
        if (height > 0) {
            height = (int)TypedValue.applyDimension(1, height, metrics);
        }
        return new RelativeLayout.LayoutParams(width, height);
    }

    public FrameLayout getContentRoot() {
        return this.mContentRoot;
    }

    private SessionParams getParams() {
        return this.mBuilder.mParams;
    }

    @Override
    public BridgeContext getContext() {
        return (BridgeContext)super.getContext();
    }

    private StatusBar createStatusBar(BridgeContext context, Density density, boolean isRtl, boolean isRtlSupported, int simulatedPlatformVersion) {
        StatusBar statusBar = new StatusBar(context, density, isRtl, isRtlSupported, simulatedPlatformVersion);
        RelativeLayout.LayoutParams params = this.createLayoutParams(-1, this.mBuilder.mStatusBarSize);
        if (this.mBuilder.isNavBarVertical()) {
            params.addRule(16, this.getId(ID_NAV_BAR));
        }
        statusBar.setLayoutParams(params);
        statusBar.setId(this.getId(ID_STATUS_BAR));
        return statusBar;
    }

    private BridgeActionBar createActionBar(BridgeContext context, SessionParams params) {
        int rule;
        boolean isMenu = "menu".equals(params.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG));
        BridgeActionBar actionBar = context.isAppCompatTheme() && !isMenu ? new AppCompatActionBar(context, params) : new FrameworkActionBar(context, params);
        RelativeLayout.LayoutParams layoutParams = this.createLayoutParams(-1, -1);
        int n = rule = this.mBuilder.isNavBarVertical() ? 16 : 2;
        if (this.mBuilder.hasNavBar() && this.mBuilder.solidBars()) {
            layoutParams.addRule(rule, this.getId(ID_NAV_BAR));
        }
        if (this.mBuilder.hasStatusBar() && this.mBuilder.solidBars()) {
            layoutParams.addRule(3, this.getId(ID_STATUS_BAR));
        }
        actionBar.getRootView().setLayoutParams(layoutParams);
        actionBar.createMenuPopup();
        return actionBar;
    }

    private TitleBar createTitleBar(BridgeContext context, String title, int simulatedPlatformVersion) {
        TitleBar titleBar = new TitleBar(context, title, simulatedPlatformVersion);
        RelativeLayout.LayoutParams params = this.createLayoutParams(-1, this.mBuilder.mTitleBarSize);
        if (this.mBuilder.hasStatusBar() && this.mBuilder.solidBars()) {
            params.addRule(3, this.getId(ID_STATUS_BAR));
        }
        if (this.mBuilder.isNavBarVertical() && this.mBuilder.solidBars()) {
            params.addRule(16, this.getId(ID_NAV_BAR));
        }
        titleBar.setLayoutParams(params);
        titleBar.setId(this.getId(ID_TITLE_BAR));
        return titleBar;
    }

    private NavigationBar createNavBar(BridgeContext context, Density density, boolean isRtl, boolean isRtlSupported, int simulatedPlatformVersion) {
        int orientation = this.mBuilder.mNavBarOrientation;
        int size = this.mBuilder.mNavBarSize;
        NavigationBar navBar = new NavigationBar(context, density, orientation, isRtl, isRtlSupported, simulatedPlatformVersion);
        boolean isVertical = this.mBuilder.isNavBarVertical();
        int w = isVertical ? size : -1;
        int h = isVertical ? -1 : size;
        RelativeLayout.LayoutParams params = this.createLayoutParams(w, h);
        params.addRule(isVertical ? 21 : 12);
        navBar.setLayoutParams(params);
        navBar.setId(this.getId(ID_NAV_BAR));
        return navBar;
    }

    private void addViews(View ... views) {
        for (View view : views) {
            if (view == null) continue;
            this.addView(view);
        }
    }

    private int getId(String name) {
        return Bridge.getResourceId(ResourceType.ID, ID_PREFIX + name);
    }

    static class Builder {
        private final SessionParams mParams;
        private final BridgeContext mContext;
        private final RenderResources mResources;
        private final boolean mWindowIsFloating;
        private ResourceValue mWindowBackground;
        private int mStatusBarSize;
        private int mNavBarSize;
        private int mNavBarOrientation;
        private int mActionBarSize;
        private int mTitleBarSize;
        private boolean mTranslucentStatus;
        private boolean mTranslucentNav;

        public Builder(SessionParams params, BridgeContext context) {
            this.mParams = params;
            this.mContext = context;
            this.mResources = this.mParams.getResources();
            this.mWindowIsFloating = ResourceHelper.getBooleanThemeValue(this.mResources, Layout.ATTR_WINDOW_FLOATING, true, true);
            this.findBackground();
            if (!this.mParams.isForceNoDecor()) {
                this.findStatusBar();
                this.findActionBar();
                this.findNavBar();
            }
        }

        private void findBackground() {
            if (!this.mParams.isBgColorOverridden()) {
                this.mWindowBackground = this.mResources.findItemInTheme(Layout.ATTR_WINDOW_BACKGROUND, true);
                this.mWindowBackground = this.mResources.resolveResValue(this.mWindowBackground);
            }
        }

        private void findStatusBar() {
            boolean windowFullScreen = ResourceHelper.getBooleanThemeValue(this.mResources, Layout.ATTR_WINDOW_FULL_SCREEN, true, false);
            if (!windowFullScreen && !this.mWindowIsFloating) {
                this.mStatusBarSize = this.getDimension(Layout.ATTR_STATUS_BAR_HEIGHT, true, 25);
                this.mTranslucentStatus = ResourceHelper.getBooleanThemeValue(this.mResources, Layout.ATTR_WINDOW_TRANSLUCENT_STATUS, true, false);
            }
        }

        private void findActionBar() {
            boolean windowActionBar;
            if (this.mWindowIsFloating) {
                return;
            }
            boolean isMenu = "menu".equals(this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_ROOT_TAG));
            boolean bl = isMenu || ResourceHelper.getBooleanThemeValue(this.mResources, Layout.ATTR_WINDOW_ACTION_BAR, !this.mContext.isAppCompatTheme(), true) ? true : (windowActionBar = false);
            if (windowActionBar) {
                this.mActionBarSize = this.getDimension(Layout.ATTR_ACTION_BAR_SIZE, true, 25);
            } else {
                boolean windowNoTitle = ResourceHelper.getBooleanThemeValue(this.mResources, Layout.ATTR_WINDOW_NO_TITLE, true, false);
                if (!windowNoTitle) {
                    this.mTitleBarSize = this.getDimension(Layout.ATTR_WINDOW_TITLE_SIZE, true, 25);
                }
            }
        }

        private void findNavBar() {
            if (this.hasSoftwareButtons() && !this.mWindowIsFloating) {
                HardwareConfig hwConfig = this.mParams.getHardwareConfig();
                boolean barOnBottom = true;
                if (hwConfig.getOrientation() == ScreenOrientation.LANDSCAPE) {
                    int shortSize = hwConfig.getScreenHeight();
                    int shortSizeDp = shortSize * 160 / hwConfig.getDensity().getDpiValue();
                    barOnBottom = shortSizeDp >= 600;
                }
                this.mNavBarOrientation = barOnBottom ? 0 : 1;
                this.mNavBarSize = this.getDimension(barOnBottom ? Layout.ATTR_NAV_BAR_HEIGHT : Layout.ATTR_NAV_BAR_WIDTH, true, 48);
                this.mTranslucentNav = ResourceHelper.getBooleanThemeValue(this.mResources, Layout.ATTR_WINDOW_TRANSLUCENT_NAV, true, false);
            }
        }

        private int getDimension(String attr2, boolean isFramework, int defaultValue) {
            TypedValue typedValue;
            ResourceValue value = this.mResources.findItemInTheme(attr2, isFramework);
            if ((value = this.mResources.resolveResValue(value)) != null && (typedValue = ResourceHelper.getValue(attr2, value.getValue(), true)) != null) {
                return (int)typedValue.getDimension(this.mContext.getMetrics());
            }
            return defaultValue;
        }

        private boolean hasSoftwareButtons() {
            return this.mParams.getHardwareConfig().hasSoftwareButtons();
        }

        private boolean solidBars() {
            return !(this.hasNavBar() && this.mTranslucentNav || this.hasStatusBar() && this.mTranslucentStatus);
        }

        private boolean hasNavBar() {
            return Config.showOnScreenNavBar(this.mParams.getSimulatedPlatformVersion()) && this.hasSoftwareButtons() && this.mNavBarSize > 0;
        }

        private boolean hasStatusBar() {
            return this.mStatusBarSize > 0;
        }

        private boolean isNavBarVertical() {
            return this.hasNavBar() && this.mNavBarOrientation == 1;
        }
    }
}

