/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import libcore.io.BufferIterator;
import libcore.io.Memory;

public class NioBufferIterator
extends BufferIterator {
    private final long address;
    private final int size;
    private final boolean swap;
    private int position;

    NioBufferIterator(long address, int size, boolean swap) {
        this.address = address;
        this.size = size;
        this.swap = swap;
    }

    @Override
    public void seek(int offset) {
        this.position = offset;
    }

    @Override
    public void skip(int byteCount) {
        this.position += byteCount;
    }

    @Override
    public void readByteArray(byte[] dst, int dstOffset, int byteCount) {
        Memory.peekByteArray(this.address + (long)this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
    }

    @Override
    public byte readByte() {
        byte result = Memory.peekByte(this.address + (long)this.position);
        ++this.position;
        return result;
    }

    @Override
    public int readInt() {
        int result = Memory.peekInt(this.address + (long)this.position, this.swap);
        this.position += 4;
        return result;
    }

    @Override
    public void readIntArray(int[] dst, int dstOffset, int intCount) {
        Memory.peekIntArray(this.address + (long)this.position, dst, dstOffset, intCount, this.swap);
        this.position += 4 * intCount;
    }

    @Override
    public short readShort() {
        short result = Memory.peekShort(this.address + (long)this.position, this.swap);
        this.position += 2;
        return result;
    }
}

