/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class BaseClassesAnalysisAction
extends BaseAnalysisAction {
    protected BaseClassesAnalysisAction(String title, String analysisNoon) {
        super(title, analysisNoon);
    }

    protected abstract void analyzeClasses(@NotNull Project var1, @NotNull AnalysisScope var2, @NotNull ProgressIndicator var3);

    @Override
    protected void analyze(final @NotNull Project project2, final @NotNull AnalysisScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/BaseClassesAnalysisAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/analysis/BaseClassesAnalysisAction", "analyze"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, AnalysisScopeBundle.message((String)"analyzing.project", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/analysis/BaseClassesAnalysisAction$1", "run"));
                }
                indicator.setIndeterminate(true);
                indicator.setText(AnalysisScopeBundle.message((String)"checking.class.files", (Object[])new Object[0]));
                if (project2.isDisposed()) {
                    return;
                }
                Set<Module> modules = BaseClassesAnalysisAction.getScopeModules(scope);
                CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
                CompileScope compileScope = compilerManager.createModulesCompileScope(modules.toArray(Module.EMPTY_ARRAY), false);
                boolean upToDate = compilerManager.isUpToDate(compileScope);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/BaseClassesAnalysisAction$1", "lambda$run$0"));
                    }
                    if (scope == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/analysis/BaseClassesAnalysisAction$1", "lambda$run$0"));
                    }
                    if (project2.isDisposed()) {
                        return;
                    }
                    if (!upToDate) {
                        int i2 = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)AnalysisScopeBundle.message((String)"recompile.confirmation.message", (Object[])new Object[0]), (String)AnalysisScopeBundle.message((String)"project.is.out.of.date", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
                        if (i2 == 2) {
                            return;
                        }
                        if (i2 == 0) {
                            BaseClassesAnalysisAction.this.compileAndAnalyze(project2, scope);
                        } else {
                            BaseClassesAnalysisAction.this.doAnalyze(project2, scope);
                        }
                    } else {
                        BaseClassesAnalysisAction.this.doAnalyze(project2, scope);
                    }
                });
            }
        });
    }

    @NotNull
    public static Set<Module> getScopeModules(@NotNull AnalysisScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/analysis/BaseClassesAnalysisAction", "getScopeModules"));
        }
        int scopeType = scope.getScopeType();
        HashSet<Module> result2 = new HashSet<Module>();
        Project project2 = scope.getProject();
        if (scopeType == 4) {
            Module module2 = scope.getModule();
            if (module2 != null) {
                result2.add(module2);
            }
        } else if (scopeType == 7) {
            result2.addAll(scope.getModules());
        } else if (scopeType == 3) {
            PsiElement element = scope.getElement();
            if (element != null) {
                VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
                BaseClassesAnalysisAction.getContainingModule(vFile, project2, result2);
            }
        } else if (scopeType == 2) {
            PsiElement element = scope.getElement();
            if (element != null) {
                VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
                Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
                BaseClassesAnalysisAction.getModulesContainedInDirectory(modules, vFile, result2);
                BaseClassesAnalysisAction.getContainingModule(vFile, project2, result2);
            }
        } else if (scopeType == 9) {
            Set files = scope.getFiles();
            Module[] modules = ModuleManager.getInstance((Project)project2).getModules();
            for (VirtualFile vFile : files) {
                BaseClassesAnalysisAction.getModulesContainedInDirectory(modules, vFile, result2);
                BaseClassesAnalysisAction.getContainingModule(vFile, project2, result2);
            }
        } else {
            result2.addAll(Arrays.asList(ModuleManager.getInstance((Project)project2).getModules()));
        }
        HashSet<Module> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/BaseClassesAnalysisAction", "getScopeModules"));
        }
        return hashSet;
    }

    private static void getContainingModule(VirtualFile vFile, @NotNull Project project2, Set<Module> result2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/BaseClassesAnalysisAction", "getContainingModule"));
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project2);
        Module module2 = fileIndex.getModuleForFile(vFile);
        if (module2 != null) {
            result2.add(module2);
        }
    }

    private static void getModulesContainedInDirectory(Module[] modules, VirtualFile directory, Set<Module> result2) {
        if (!directory.isDirectory()) {
            return;
        }
        block0: for (Module module2 : modules) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)root, (boolean)false)) continue;
                result2.add(module2);
                continue block0;
            }
        }
    }

    private void doAnalyze(final @NotNull Project project2, final @NotNull AnalysisScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/BaseClassesAnalysisAction", "doAnalyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/analysis/BaseClassesAnalysisAction", "doAnalyze"));
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, AnalysisScopeBundle.message((String)"analyzing.project", (Object[])new Object[0]), true){

            public Task.NotificationInfo getNotificationInfo() {
                return new Task.NotificationInfo("Analysis", "\"" + this.getTitle() + "\" Analysis Finished", "");
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/analysis/BaseClassesAnalysisAction$2", "run"));
                }
                BaseClassesAnalysisAction.this.analyzeClasses(project2, scope, indicator);
            }
        });
    }

    private void compileAndAnalyze(final @NotNull Project project2, final @NotNull AnalysisScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/BaseClassesAnalysisAction", "compileAndAnalyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/analysis/BaseClassesAnalysisAction", "compileAndAnalyze"));
        }
        if (project2.isDisposed()) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        compilerManager.make(compilerManager.createProjectCompileScope(project2), new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (aborted || errors != 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/BaseClassesAnalysisAction$3", "lambda$finished$0"));
                    }
                    if (scope == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/analysis/BaseClassesAnalysisAction$3", "lambda$finished$0"));
                    }
                    BaseClassesAnalysisAction.this.doAnalyze(project2, scope);
                });
            }
        });
    }
}

