/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptorWithPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorOptionsTree
extends Tree {
    private final String myCategoryName;
    private final DefaultTreeModel myTreeModel;
    private static final Comparator<EditorSchemeAttributeDescriptor> ATTR_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.toString(), (String)o2.toString());

    public ColorOptionsTree(@NotNull String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "categoryName", "com/intellij/application/options/colors/ColorOptionsTree", "<init>"));
        }
        super(ColorOptionsTree.createTreeModel());
        this.myTreeModel = (DefaultTreeModel)this.getModel();
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.myCategoryName = categoryName;
        new TreeSpeedSearch(this, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
    }

    public void fillOptions(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorOptionsTree", "fillOptions"));
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (EditorSchemeAttributeDescriptor description : this.getOrderedDescriptors(options)) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            List<String> path = ColorOptionsTree.extractPath(description);
            if (path != null && path.size() > 1) {
                MyTreeNode groupNode = ColorOptionsTree.ensureGroup(root, path, 0);
                groupNode.add(new MyTreeNode(description, path.get(path.size() - 1)));
                continue;
            }
            root.add(new MyTreeNode(description));
        }
        this.myTreeModel.setRoot(root);
    }

    public void setEmptyText(@NotNull String text, @Nullable ActionListener linkListener) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/colors/ColorOptionsTree", "setEmptyText"));
        }
        StatusText statusText = this.getEmptyText();
        if (linkListener != null) {
            statusText.clear();
            statusText.appendText(text + ' ');
            statusText.appendText("More...", SimpleTextAttributes.LINK_ATTRIBUTES, linkListener);
        } else {
            statusText.setText(text);
        }
    }

    private static TreeModel createTreeModel() {
        return new DefaultTreeModel((TreeNode)new DefaultMutableTreeTableNode());
    }

    private Collection<EditorSchemeAttributeDescriptor> getOrderedDescriptors(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/ColorOptionsTree", "getOrderedDescriptors"));
        }
        ArrayList list = ContainerUtil.newArrayList();
        for (EditorSchemeAttributeDescriptor description : options.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            list.add(description);
        }
        Collections.sort(list, ATTR_COMPARATOR);
        return list;
    }

    @Nullable
    public EditorSchemeAttributeDescriptor getSelectedDescriptor() {
        Object selectedValue = this.getSelectedValue();
        return selectedValue instanceof EditorSchemeAttributeDescriptor ? (EditorSchemeAttributeDescriptor)selectedValue : null;
    }

    @Nullable
    public Object getSelectedValue() {
        Object selectedNode = this.getLastSelectedPathComponent();
        if (selectedNode instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)selectedNode).getUserObject();
        }
        return null;
    }

    public void selectOptionByType(final @NotNull String attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeType", "com/intellij/application/options/colors/ColorOptionsTree", "selectOptionByType"));
        }
        this.selectPath(this.findOption(this.myTreeModel.getRoot(), new DescriptorMatcher(){

            @Override
            public boolean matches(@NotNull Object data) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/colors/ColorOptionsTree$1", "matches"));
                }
                if (data instanceof EditorSchemeAttributeDescriptor) {
                    return attributeType.equals(((EditorSchemeAttributeDescriptor)data).getType());
                }
                return false;
            }
        }));
    }

    public void selectOptionByName(final @NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionName", "com/intellij/application/options/colors/ColorOptionsTree", "selectOptionByName"));
        }
        this.selectPath(this.findOption(this.myTreeModel.getRoot(), new DescriptorMatcher(){

            @Override
            public boolean matches(@NotNull Object data) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/colors/ColorOptionsTree$2", "matches"));
                }
                return !optionName.isEmpty() && StringUtil.containsIgnoreCase((String)data.toString(), (String)optionName);
            }
        }));
    }

    @Nullable
    private TreePath findOption(@NotNull Object nodeObject, @NotNull DescriptorMatcher matcher) {
        if (nodeObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeObject", "com/intellij/application/options/colors/ColorOptionsTree", "findOption"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/application/options/colors/ColorOptionsTree", "findOption"));
        }
        for (int i2 = 0; i2 < this.myTreeModel.getChildCount(nodeObject); ++i2) {
            Object data;
            Object childObject = this.myTreeModel.getChild(nodeObject, i2);
            if (childObject instanceof MyTreeNode && matcher.matches(data = ((MyTreeNode)childObject).getUserObject())) {
                return new TreePath(this.myTreeModel.getPathToRoot((MyTreeNode)childObject));
            }
            TreePath pathInChild = this.findOption(childObject, matcher);
            if (pathInChild == null) continue;
            return pathInChild;
        }
        return null;
    }

    private void selectPath(@Nullable TreePath path) {
        if (path != null) {
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    @Nullable
    private static List<String> extractPath(@NotNull EditorSchemeAttributeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/application/options/colors/ColorOptionsTree", "extractPath"));
        }
        if (descriptor instanceof EditorSchemeAttributeDescriptorWithPath) {
            String name = descriptor.toString();
            ArrayList<String> path = new ArrayList<String>();
            int separatorStart = name.indexOf("//");
            int nextChunkStart = 0;
            while (separatorStart > 0) {
                path.add(name.substring(nextChunkStart, separatorStart));
                nextChunkStart = separatorStart + "//".length();
                separatorStart = name.indexOf("//", nextChunkStart);
            }
            if (nextChunkStart < name.length()) {
                path.add(name.substring(nextChunkStart));
            }
            return path;
        }
        return null;
    }

    private static MyTreeNode ensureGroup(@NotNull DefaultMutableTreeNode root, @NotNull List<String> path, int index) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/application/options/colors/ColorOptionsTree", "ensureGroup"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/application/options/colors/ColorOptionsTree", "ensureGroup"));
        }
        String groupName = path.get(index++);
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            TreeNode child = root.getChildAt(i2);
            if (!(child instanceof MyTreeNode) || !groupName.equals(child.toString())) continue;
            return index < path.size() - 1 ? ColorOptionsTree.ensureGroup((MyTreeNode)child, path, index) : (MyTreeNode)child;
        }
        MyTreeNode groupNode = new MyTreeNode(groupName);
        root.add(groupNode);
        return index < path.size() - 1 ? ColorOptionsTree.ensureGroup(groupNode, path, index) : groupNode;
    }

    private static interface DescriptorMatcher {
        public boolean matches(@NotNull Object var1);
    }

    private static class MyTreeNode
    extends DefaultMutableTreeNode {
        private final String myName;

        public MyTreeNode(@NotNull EditorSchemeAttributeDescriptor descriptor, @NotNull String name) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/application/options/colors/ColorOptionsTree$MyTreeNode", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/colors/ColorOptionsTree$MyTreeNode", "<init>"));
            }
            super(descriptor);
            this.myName = name;
        }

        public MyTreeNode(@NotNull EditorSchemeAttributeDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/application/options/colors/ColorOptionsTree$MyTreeNode", "<init>"));
            }
            super(descriptor);
            this.myName = descriptor.toString();
        }

        public MyTreeNode(@NotNull String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/application/options/colors/ColorOptionsTree$MyTreeNode", "<init>"));
            }
            super(groupName);
            this.myName = groupName;
        }

        @Override
        public String toString() {
            return this.myName;
        }
    }
}

