/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.impl.TemplateExpandShortcutPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.xml.XmlBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetCompositeConfigurable
extends SearchableConfigurable.Parent.Abstract {
    private final Configurable[] myNestedConfigurables;
    @NotNull
    private final Configurable[] myInnerConfigurables;
    private TemplateExpandShortcutPanel myTemplateExpandShortcutPanel;

    public EmmetCompositeConfigurable(Configurable ... innerConfigurables) {
        if (innerConfigurables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerConfigurables", "com/intellij/application/options/emmet/EmmetCompositeConfigurable", "<init>"));
        }
        this(Collections.emptyList(), innerConfigurables);
    }

    public EmmetCompositeConfigurable(Collection<Configurable> nestedConfigurables, Configurable ... innerConfigurables) {
        if (innerConfigurables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerConfigurables", "com/intellij/application/options/emmet/EmmetCompositeConfigurable", "<init>"));
        }
        this.myNestedConfigurables = nestedConfigurables.toArray(new Configurable[nestedConfigurables.size()]);
        this.myInnerConfigurables = innerConfigurables;
        this.myTemplateExpandShortcutPanel = new TemplateExpandShortcutPanel(XmlBundle.message((String)"emmet.expand.abbreviation.with", (Object[])new Object[0]));
    }

    @Nls
    public String getDisplayName() {
        return XmlBundle.message((String)"emmet.configuration.title", (Object[])new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return this.getId();
    }

    @Nullable
    public JComponent createComponent() {
        JPanel rootPanel = new JPanel((LayoutManager)new GridLayoutManager(this.myInnerConfigurables.length + 1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        rootPanel.add((Component)this.myTemplateExpandShortcutPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        for (int i2 = 0; i2 < this.myInnerConfigurables.length; ++i2) {
            Configurable configurable = this.myInnerConfigurables[i2];
            JComponent component = configurable.createComponent();
            assert (component != null);
            int vSizePolicy = 3;
            if (i2 + 1 == this.myInnerConfigurables.length) {
                vSizePolicy |= 4;
            }
            rootPanel.add((Component)component, new GridConstraints(i2 + 1, 0, 1, 1, 9, 3, 7, vSizePolicy, null, null, null));
        }
        rootPanel.revalidate();
        return rootPanel;
    }

    public void reset() {
        this.myTemplateExpandShortcutPanel.setSelectedChar((char)EmmetOptions.getInstance().getEmmetExpandShortcut());
        for (Configurable configurable : this.myInnerConfigurables) {
            configurable.reset();
        }
        super.reset();
    }

    public void apply() throws ConfigurationException {
        EmmetOptions.getInstance().setEmmetExpandShortcut(this.myTemplateExpandShortcutPanel.getSelectedChar());
        for (Configurable configurable : this.myInnerConfigurables) {
            configurable.reset();
        }
        super.apply();
    }

    public boolean isModified() {
        if (EmmetOptions.getInstance().getEmmetExpandShortcut() != this.myTemplateExpandShortcutPanel.getSelectedChar() || super.isModified()) {
            return true;
        }
        for (Configurable configurable : this.myInnerConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void disposeUIResources() {
        this.myTemplateExpandShortcutPanel = null;
        super.disposeUIResources();
    }

    @NotNull
    public String getId() {
        if ("reference.idesettings.emmet" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/emmet/EmmetCompositeConfigurable", "getId"));
        }
        return "reference.idesettings.emmet";
    }

    public boolean hasOwnContent() {
        return true;
    }

    protected Configurable[] buildConfigurables() {
        return this.myNestedConfigurables;
    }
}

