/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.DescriptionAwareSchemeActions;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDescriptionAwareSchemesPanel<T extends Scheme>
extends AbstractSchemesPanel<T, JPanel> {
    private static final String SHOW_DESCRIPTION_CARD = "show.description.card";
    private static final String EDIT_DESCRIPTION_CARD = "edit.description.card";
    private static final String ERROR_CARD = "error.card";
    private static final KeyStroke ESC_KEY_STROKE = KeyStroke.getKeyStroke(27, 0, false);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);
    private DescriptionLabel myDescriptionLabel;
    private JLabel myWarningLabel;
    private JBTextField myDescriptionTextField;
    private CardLayout myLayout;

    @Override
    @NotNull
    protected JPanel createInfoComponent() {
        JPanel panel2 = new JPanel();
        this.myLayout = new CardLayout();
        panel2.setLayout(this.myLayout);
        this.myDescriptionTextField = new JBTextField();
        this.myDescriptionTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractDescriptionAwareSchemesPanel.this.applyDescription();
            }
        });
        this.myDescriptionTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDescriptionAwareSchemesPanel.this.showDescription();
                AbstractDescriptionAwareSchemesPanel.this.getConfigurableFocusComponent().requestFocus();
            }
        }, ESC_KEY_STROKE, 0);
        this.myDescriptionTextField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDescriptionAwareSchemesPanel.this.applyDescription();
                AbstractDescriptionAwareSchemesPanel.this.getConfigurableFocusComponent().requestFocus();
            }
        }, ENTER_KEY_STROKE, 0);
        this.myDescriptionLabel = new DescriptionLabel();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/schemes/AbstractDescriptionAwareSchemesPanel$4", "onClick"));
                }
                if (clickCount != 2) {
                    return false;
                }
                AbstractDescriptionAwareSchemesPanel.this.editDescription(AbstractDescriptionAwareSchemesPanel.this.myDescriptionLabel.getText());
                return true;
            }
        }.installOn((Component)this.myDescriptionLabel);
        this.myWarningLabel = new JLabel();
        panel2.add((Component)this.myDescriptionTextField, EDIT_DESCRIPTION_CARD);
        panel2.add((Component)this.myDescriptionLabel, SHOW_DESCRIPTION_CARD);
        panel2.add((Component)this.myWarningLabel, ERROR_CARD);
        this.myLayout.show(panel2, ERROR_CARD);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/AbstractDescriptionAwareSchemesPanel", "createInfoComponent"));
        }
        return jPanel;
    }

    @Override
    public final void showMessage(@Nullable String message, @NotNull MessageType messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "com/intellij/application/options/schemes/AbstractDescriptionAwareSchemesPanel", "showMessage"));
        }
        this.myWarningLabel.setText(message);
        this.myWarningLabel.setForeground(messageType.getTitleForeground());
        this.myLayout.show(this.myInfoComponent, ERROR_CARD);
    }

    @Override
    public void selectScheme(@Nullable T scheme2) {
        super.selectScheme(scheme2);
        if (scheme2 != null) {
            this.showDescription();
        }
    }

    @Override
    public final void clearMessage() {
        this.myLayout.show(this.myInfoComponent, SHOW_DESCRIPTION_CARD);
    }

    public void showDescription() {
        String newDescription = ((DescriptionAwareSchemeActions)this.getActions()).getDescription(this.getSelectedScheme());
        this.myDescriptionLabel.setAllText(StringUtil.notNullize((String)newDescription));
        this.myLayout.show(this.myInfoComponent, SHOW_DESCRIPTION_CARD);
    }

    public void editDescription(@Nullable String startValue) {
        this.myLayout.show(this.myInfoComponent, EDIT_DESCRIPTION_CARD);
        this.myDescriptionTextField.setText(StringUtil.notNullize((String)startValue));
        IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
        fm.doWhenFocusSettlesDown(() -> fm.requestFocus((Component)this.myDescriptionTextField, true));
    }

    @NotNull
    protected abstract JComponent getConfigurableFocusComponent();

    private void applyDescription() {
        ((DescriptionAwareSchemeActions)this.getActions()).setDescription(this.getSelectedScheme(), this.myDescriptionTextField.getText());
        this.showDescription();
    }

    private static class DescriptionLabel
    extends MultiLineLabel {
        private String myAllText;

        public DescriptionLabel() {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this);
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(2);
        }

        public void setAllText(String allText) {
            this.myAllText = allText;
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getSize().width;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int charWidth = fontMetrics.charWidth('a');
            int firstLineSize = Math.max(0, width / charWidth);
            if (this.myAllText.length() <= firstLineSize) {
                this.setText(this.myAllText);
                this.setToolTipText(null);
            } else {
                String firstLine = this.myAllText.substring(0, firstLineSize);
                String remainPart = this.myAllText.substring(firstLineSize);
                int lastWhitespace = firstLine.lastIndexOf(32);
                if (lastWhitespace > -1) {
                    remainPart = firstLine.substring(lastWhitespace) + remainPart;
                    firstLine = firstLine.substring(0, lastWhitespace);
                }
                String visibleText = firstLine + "\n";
                int secondLineSize = Math.max(0, (width - 3 * fontMetrics.charWidth('.')) / charWidth);
                if (remainPart.length() <= secondLineSize) {
                    this.setText(visibleText + remainPart.trim());
                    this.setToolTipText(null);
                } else {
                    this.setText(visibleText + remainPart.trim().substring(0, secondLineSize) + "...");
                    this.setToolTipText("..." + remainPart.substring(secondLineSize));
                }
            }
            super.paintComponent(g);
        }
    }
}

