/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.function.Predicate;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesCombo<T extends Scheme>
extends ComboBox<MySchemeListItem<T>> {
    public static final String PROJECT_LEVEL = "Project";
    public static final String IDE_LEVEL = "IDE";

    public SchemesCombo() {
        super(new MyComboBoxModel());
        this.setRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
    }

    public void resetSchemes(@NotNull Collection<T> schemes) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/application/options/schemes/SchemesCombo", "resetSchemes"));
        }
        MyComboBoxModel model = (MyComboBoxModel)this.getModel();
        model.removeAllElements();
        if (this.supportsProjectSchemes()) {
            model.addElement(new MySeparatorItem(PROJECT_LEVEL));
            this.addItems(schemes, scheme2 -> this.isProjectScheme(scheme2));
            model.addElement(new MySeparatorItem(IDE_LEVEL));
            this.addItems(schemes, scheme2 -> !this.isProjectScheme(scheme2));
        } else {
            this.addItems(schemes, scheme2 -> true);
        }
    }

    public void selectScheme(@Nullable T scheme2) {
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            if (((MySchemeListItem)this.getItemAt(i2)).getScheme() != scheme2) continue;
            this.setSelectedIndex(i2);
            break;
        }
    }

    @Nullable
    public T getSelectedScheme() {
        Object item = this.getSelectedItem();
        return item != null ? (T)((MySchemeListItem)item).getScheme() : null;
    }

    @Nullable
    public MySchemeListItem<T> getSelectedItem() {
        int i2 = this.getSelectedIndex();
        return i2 >= 0 ? (MySchemeListItem)this.getItemAt(i2) : null;
    }

    protected abstract boolean supportsProjectSchemes();

    protected boolean isProjectScheme(@NotNull T scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/schemes/SchemesCombo", "isProjectScheme"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract SimpleTextAttributes getSchemeAttributes(T var1);

    private void addItems(@NotNull Collection<T> schemes, Predicate<T> filter) {
        if (schemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemes", "com/intellij/application/options/schemes/SchemesCombo", "addItems"));
        }
        for (Scheme scheme2 : schemes) {
            if (!filter.test(scheme2)) continue;
            ((MyComboBoxModel)this.getModel()).addElement(new MySchemeListItem<Scheme>(scheme2));
        }
    }

    private class MySeparatorItem
    extends MySchemeListItem<T> {
        private String myTitle;

        public MySeparatorItem(String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/schemes/SchemesCombo$MySeparatorItem", "<init>"));
            }
            super(null);
            this.myTitle = title;
        }

        @Override
        public boolean isSeparator() {
            return true;
        }

        @Override
        @NotNull
        public String getPresentableText() {
            String string = this.myTitle;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/SchemesCombo$MySeparatorItem", "getPresentableText"));
            }
            return string;
        }
    }

    private static class MyComboBoxModel<T extends Scheme>
    extends DefaultComboBoxModel<MySchemeListItem<T>> {
        private MyComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof MySchemeListItem && ((MySchemeListItem)anObject).isSeparator()) {
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<MySchemeListItem<T>> {
        private ListCellRendererWrapper<MySchemeListItem> myWrapper = new ListCellRendererWrapper<MySchemeListItem>(){

            public void customize(JList list, MySchemeListItem value, int index, boolean selected, boolean hasFocus) {
                if (value.isSeparator()) {
                    this.setText(" Stored in " + value.getPresentableText());
                    this.setSeparator();
                }
            }
        };

        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends MySchemeListItem<T>> list, MySchemeListItem<T> value, int index, boolean selected, boolean hasFocus) {
            Component c;
            if (value != null && value.isSeparator() && (c = this.myWrapper.getListCellRendererComponent(list, value, index, selected, hasFocus)) instanceof TitledSeparator) {
                ((TitledSeparator)c).getLabel().setForeground((Color)JBColor.GRAY);
                return c;
            }
            return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MySchemeListItem<T>> list, MySchemeListItem<T> value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/schemes/SchemesCombo$MyListCellRenderer", "customizeCellRenderer"));
            }
            Object scheme2 = value.getScheme();
            if (scheme2 != null) {
                this.append(value.getPresentableText(), SchemesCombo.this.getSchemeAttributes(scheme2));
                if (SchemesCombo.this.supportsProjectSchemes() && index == -1) {
                    this.append("  " + (SchemesCombo.this.isProjectScheme(scheme2) ? SchemesCombo.PROJECT_LEVEL : SchemesCombo.IDE_LEVEL), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }
    }

    static class MySchemeListItem<T extends Scheme> {
        @Nullable
        private T myScheme;

        public MySchemeListItem(@Nullable T scheme2) {
            this.myScheme = scheme2;
        }

        @Nullable
        public String getSchemeName() {
            return this.myScheme != null ? this.myScheme.getName() : null;
        }

        @Nullable
        public T getScheme() {
            return this.myScheme;
        }

        @NotNull
        public String getPresentableText() {
            String string = this.myScheme != null ? SchemeManager.getDisplayName(this.myScheme) : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/schemes/SchemesCombo$MySchemeListItem", "getPresentableText"));
            }
            return string;
        }

        public boolean isSeparator() {
            return false;
        }
    }
}

