/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.Collection;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = "Rearrange code";
    public static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"process.rearrange.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance(RearrangeCodeProcessor.class);
    private SelectionModel mySelectionModel;

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor) {
        if (previousProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousProcessor", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
    }

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @NotNull SelectionModel selectionModel) {
        if (previousProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousProcessor", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
        this.mySelectionModel = selectionModel;
    }

    public RearrangeCodeProcessor(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
    }

    public RearrangeCodeProcessor(@NotNull Project project2, @NotNull PsiFile[] files, @NotNull String commandName, @Nullable Runnable postRunnable) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(project2, files, PROGRESS_TEXT, commandName, postRunnable, false);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "lambda$prepareTask$0"));
            }
            try {
                Collection<TextRange> ranges = this.getRangesToFormat(file2, processChangedTextOnly);
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
                if (document != null && Rearranger.EXTENSION.forLanguage(file2.getLanguage()) != null) {
                    PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
                    PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
                    Runnable command = this.prepareRearrangeCommand(file2, ranges);
                    try {
                        CommandProcessor.getInstance().executeCommand(this.myProject, command, COMMAND_NAME, null);
                    }
                    finally {
                        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
                    }
                }
                return true;
            }
            catch (FilesTooBigForDiffException e) {
                this.handleFileTooBigException(LOG, e, file2);
                return false;
            }
        });
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        return futureTask;
    }

    @NotNull
    private Runnable prepareRearrangeCommand(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareRearrangeCommand"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareRearrangeCommand"));
        }
        ArrangementEngine engine = (ArrangementEngine)ServiceManager.getService((Project)this.myProject, ArrangementEngine.class);
        Runnable runnable2 = () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "lambda$prepareRearrangeCommand$1"));
            }
            if (ranges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "lambda$prepareRearrangeCommand$1"));
            }
            engine.arrange(file2, ranges);
            if (this.getInfoCollector() != null) {
                String info = engine.getUserNotificationInfo();
                this.getInfoCollector().setRearrangeCodeNotification(info);
            }
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareRearrangeCommand"));
        }
        return runnable2;
    }

    public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file2, boolean processChangedTextOnly) throws FilesTooBigForDiffException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "getRangesToFormat"));
        }
        if (this.mySelectionModel != null) {
            return RearrangeCodeProcessor.getSelectedRanges(this.mySelectionModel);
        }
        if (processChangedTextOnly) {
            return FormatChangedTextUtil.getInstance().getChangedTextRanges(this.myProject, file2);
        }
        return ContainerUtil.newSmartList((Object)file2.getTextRange());
    }
}

