/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class DtdCompletionContributor
extends CompletionContributor {
    private static final String[] KEYWORDS = new String[]{"#PCDATA", "#IMPLIED", "#REQUIRED", "#FIXED", "<!ATTLIST", "<!ELEMENT", "<!NOTATION", "INCLUDE", "IGNORE", "CDATA", "ID", "IDREF", "EMPTY", "ANY", "IDREFS", "ENTITIES", "ENTITY", "<!ENTITY", "NMTOKEN", "NMTOKENS", "SYSTEM", "PUBLIC"};
    private static final InsertHandler<LookupElement> INSERT_HANDLER = new BasicInsertHandler<LookupElement>(){

        @Override
        public void handleInsert(InsertionContext context, LookupElement item) {
            super.handleInsert(context, item);
            if (item.getObject().toString().startsWith("<!")) {
                context.commitDocument();
                int caretOffset = context.getEditor().getCaretModel().getOffset();
                PsiElement tag = PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), PsiNamedElement.class);
                if (tag == null) {
                    context.getEditor().getDocument().insertString(caretOffset, (CharSequence)" >");
                    context.getEditor().getCaretModel().moveToOffset(caretOffset + 1);
                }
            }
        }
    };

    public DtdCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result2) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/DtdCompletionContributor$2", "addCompletions"));
                }
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/DtdCompletionContributor$2", "addCompletions"));
                }
                PsiElement position = parameters.getPosition();
                PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
                if (prev != null && DtdCompletionContributor.hasDtdKeywordCompletion(prev)) {
                    DtdCompletionContributor.addKeywordCompletions(result2.withPrefixMatcher(DtdCompletionContributor.keywordPrefix(position, result2.getPrefixMatcher().getPrefix())));
                }
                if (prev != null && prev.textMatches((CharSequence)"%")) {
                    DtdCompletionContributor.addEntityCompletions(result2, position);
                }
            }
        });
    }

    @NotNull
    private static String keywordPrefix(@NotNull PsiElement position, @NotNull String prefix) {
        PsiElement prevPrevLeaf;
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/DtdCompletionContributor", "keywordPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/completion/DtdCompletionContributor", "keywordPrefix"));
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)position);
        PsiElement psiElement = prevPrevLeaf = prevLeaf != null ? PsiTreeUtil.prevLeaf((PsiElement)prevLeaf) : null;
        if (prevLeaf != null) {
            String prevLeafText = prevLeaf.getText();
            if ("#".equals(prevLeafText)) {
                prefix = "#" + prefix;
            } else if ("!".equals(prevLeafText) && prevPrevLeaf != null && "<".equals(prevPrevLeaf.getText())) {
                prefix = "<!" + prefix;
            }
        }
        String string = prefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/DtdCompletionContributor", "keywordPrefix"));
        }
        return string;
    }

    private static void addKeywordCompletions(@NotNull CompletionResultSet result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/DtdCompletionContributor", "addKeywordCompletions"));
        }
        for (String keyword : KEYWORDS) {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)keyword).withInsertHandler(INSERT_HANDLER));
        }
    }

    private static void addEntityCompletions(final @NotNull CompletionResultSet result2, PsiElement position) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/DtdCompletionContributor", "addEntityCompletions"));
        }
        PsiElementProcessor processor2 = new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                XmlEntityDecl xmlEntityDecl;
                String name;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/DtdCompletionContributor$3", "execute"));
                }
                if (element instanceof XmlEntityDecl && (name = (xmlEntityDecl = (XmlEntityDecl)element).getName()) != null && xmlEntityDecl.isInternalReference()) {
                    result2.addElement((LookupElement)LookupElementBuilder.create((String)name).withInsertHandler((InsertHandler)XmlCompletionContributor.ENTITY_INSERT_HANDLER));
                }
                return true;
            }
        };
        XmlUtil.processXmlElements((XmlElement)((XmlFile)position.getContainingFile().getOriginalFile()), processor2, true);
    }

    private static boolean hasDtdKeywordCompletion(@NotNull PsiElement prev) {
        if (prev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prev", "com/intellij/codeInsight/completion/DtdCompletionContributor", "hasDtdKeywordCompletion"));
        }
        return prev.textMatches((CharSequence)"#") || prev.textMatches((CharSequence)"!") || prev.textMatches((CharSequence)"(") || prev.textMatches((CharSequence)",") || prev.textMatches((CharSequence)"|") || prev.textMatches((CharSequence)"[") || prev.getNode().getElementType() == XmlTokenType.XML_NAME;
    }
}

