/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.MemberLookupHelper;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConstructorCallElement
extends LookupElementDecorator<LookupElement>
implements TypedLookupItem {
    private static final Key<JavaConstructorCallElement> WRAPPING_CONSTRUCTOR_CALL = Key.create((String)"WRAPPING_CONSTRUCTOR_CALL");
    @NotNull
    private final PsiMethod myConstructor;
    @NotNull
    private final PsiClassType myType;
    @NotNull
    private final PsiSubstitutor mySubstitutor;

    private JavaConstructorCallElement(@NotNull LookupElement classItem, @NotNull PsiMethod constructor, @NotNull PsiClassType type) {
        if (classItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classItem", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "<init>"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "<init>"));
        }
        super(classItem);
        this.myConstructor = constructor;
        this.myType = type;
        this.mySubstitutor = this.myType.resolveGenerics().getSubstitutor();
    }

    private void markClassItemWrapped(@NotNull LookupElement classItem) {
        if (classItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classItem", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "markClassItemWrapped"));
        }
        LookupElement delegate = classItem;
        while (true) {
            delegate.putUserData(WRAPPING_CONSTRUCTOR_CALL, (Object)this);
            if (!(delegate instanceof LookupElementDecorator)) break;
            delegate = ((LookupElementDecorator)delegate).getDelegate();
        }
    }

    public void handleInsert(InsertionContext context) {
        this.markClassItemWrapped(this.getDelegate());
        super.handleInsert(context);
    }

    @NotNull
    public PsiMethod getObject() {
        PsiMethod psiMethod = this.myConstructor;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "getObject"));
        }
        return psiMethod;
    }

    public boolean equals(Object o) {
        return this == o || super.equals(o) && this.myConstructor.equals(((JavaConstructorCallElement)o).myConstructor);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myConstructor.hashCode();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiClassType psiClassType = this.myType;
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "getType"));
        }
        return psiClassType;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        String tailText = StringUtil.notNullize((String)presentation.getTailText());
        int genericsEnd = tailText.lastIndexOf(62) + 1;
        presentation.clearTail();
        presentation.appendTailText(tailText.substring(0, genericsEnd), false);
        presentation.appendTailText(MemberLookupHelper.getMethodParameterString(this.myConstructor, this.mySubstitutor), false);
        presentation.appendTailText(tailText.substring(genericsEnd), true);
    }

    static List<? extends LookupElement> wrap(@NotNull JavaPsiClassReferenceElement classItem, @NotNull PsiElement position) {
        if (classItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classItem", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "wrap"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "wrap"));
        }
        PsiClass psiClass = classItem.getObject();
        return JavaConstructorCallElement.wrap((LookupElement)classItem, psiClass, position, () -> JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(psiClass, PsiSubstitutor.EMPTY));
    }

    static List<? extends LookupElement> wrap(@NotNull LookupElement classItem, @NotNull PsiClass psiClass, @NotNull PsiElement position, @NotNull Supplier<PsiClassType> type) {
        List constructors;
        if (classItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classItem", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "wrap"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "wrap"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "wrap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "wrap"));
        }
        if (Registry.is((String)"java.completion.show.constructors") && JavaConstructorCallElement.isConstructorCallPlace(position) && !(constructors = ContainerUtil.filter((Object[])psiClass.getConstructors(), c -> {
            if (psiClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "lambda$wrap$1"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "lambda$wrap$1"));
            }
            return JavaConstructorCallElement.shouldSuggestConstructor(psiClass, position, c);
        })).isEmpty()) {
            return ContainerUtil.map((Collection)constructors, c -> {
                if (classItem == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classItem", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "lambda$wrap$2"));
                }
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "lambda$wrap$2"));
                }
                return new JavaConstructorCallElement(classItem, (PsiMethod)c, (PsiClassType)type.get());
            });
        }
        return Collections.singletonList(classItem);
    }

    private static boolean shouldSuggestConstructor(@NotNull PsiClass psiClass, @NotNull PsiElement position, PsiMethod constructor) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "shouldSuggestConstructor"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "shouldSuggestConstructor"));
        }
        return JavaResolveUtil.isAccessible((PsiMember)constructor, psiClass, constructor.getModifierList(), position, null, null) || JavaConstructorCallElement.willBeAccessibleInAnonymous(psiClass, constructor);
    }

    private static boolean willBeAccessibleInAnonymous(@NotNull PsiClass psiClass, PsiMethod constructor) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "willBeAccessibleInAnonymous"));
        }
        return !constructor.hasModifierProperty("private") && psiClass.hasModifierProperty("abstract");
    }

    private static boolean isConstructorCallPlace(@NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "isConstructorCallPlace"));
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)position, () -> {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "lambda$isConstructorCallPlace$3"));
            }
            boolean result2 = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position) && !JavaClassNameInsertHandler.isArrayTypeExpected((PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiNewExpression.class));
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{position});
        });
    }

    @Nullable
    static PsiMethod extractCalledConstructor(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaConstructorCallElement", "extractCalledConstructor"));
        }
        JavaConstructorCallElement callItem = (JavaConstructorCallElement)element.getUserData(WRAPPING_CONSTRUCTOR_CALL);
        return callItem != null ? callItem.getObject() : null;
    }
}

