/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CheckInitialized;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.StaticallyImportable;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.filters.getters.MembersGetter;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.proximity.KnownElementWeigher;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PreferByKindWeigher
extends LookupElementWeigher {
    static final ElementPattern<PsiElement> IN_CATCH_TYPE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeElement.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiCatchSection.class), PsiJavaPatterns.psiElement(PsiVariable.class).withParent(PsiCatchSection.class)}))));
    static final ElementPattern<PsiElement> IN_MULTI_CATCH_TYPE = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiCatchSection.class)), PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("|")).withParent(PsiTypeElement.class)).withSuperParent(2, PsiParameter.class)).withSuperParent(3, PsiCatchSection.class))});
    static final ElementPattern<PsiElement> INSIDE_METHOD_THROWS_CLAUSE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"throws", ","})).inside((ElementPattern)PsiJavaPatterns.psiElement((IElementType)JavaElementType.THROWS_LIST));
    static final ElementPattern<PsiElement> IN_RESOURCE = PsiJavaPatterns.psiElement().withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent(PsiTypeElement.class)).withSuperParent(2, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiResourceVariable.class), PsiJavaPatterns.psiElement(PsiResourceList.class)})), PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiResourceExpression.class)}));
    private final CompletionType myCompletionType;
    private final PsiElement myPosition;
    private final Set<PsiField> myNonInitializedFields;
    private final Condition<PsiClass> myRequiredSuper;
    private final ExpectedTypeInfo[] myExpectedTypes;

    public PreferByKindWeigher(CompletionType completionType, PsiElement position, ExpectedTypeInfo[] expectedTypes) {
        super("kind");
        this.myCompletionType = completionType;
        this.myPosition = position;
        this.myNonInitializedFields = CheckInitialized.getNonInitializedFields(position);
        this.myRequiredSuper = PreferByKindWeigher.createSuitabilityCondition(position);
        this.myExpectedTypes = expectedTypes;
    }

    @NotNull
    private static Condition<PsiClass> createSuitabilityCondition(PsiElement position) {
        if (IN_CATCH_TYPE.accepts((Object)position) || IN_MULTI_CATCH_TYPE.accepts((Object)position)) {
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiTryStatement.class);
            ArrayList thrownExceptions = ContainerUtil.newArrayList();
            if (tryStatement != null && tryStatement.getTryBlock() != null) {
                for (PsiClassType type : ExceptionUtil.getThrownExceptions((PsiElement)tryStatement.getTryBlock())) {
                    ContainerUtil.addIfNotNull((Collection)thrownExceptions, (Object)type.resolve());
                }
            }
            if (thrownExceptions.isEmpty()) {
                ContainerUtil.addIfNotNull((Collection)thrownExceptions, (Object)JavaPsiFacade.getInstance((Project)position.getProject()).findClass("java.lang.Throwable", position.getResolveScope()));
            }
            Condition condition = psiClass -> {
                for (PsiClass exception : thrownExceptions) {
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)exception, (boolean)true)) continue;
                    return true;
                }
                return false;
            };
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "createSuitabilityCondition"));
            }
            return condition;
        }
        if (JavaSmartCompletionContributor.AFTER_THROW_NEW.accepts((Object)position) || INSIDE_METHOD_THROWS_CLAUSE.accepts((Object)position)) {
            Condition condition = psiClass -> InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Throwable");
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "createSuitabilityCondition"));
            }
            return condition;
        }
        if (IN_RESOURCE.accepts((Object)position)) {
            Condition condition = psiClass -> InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.AutoCloseable");
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "createSuitabilityCondition"));
            }
            return condition;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).accepts((Object)position)) {
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class);
            assert (annotation != null);
            PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner());
            Condition condition = psiClass -> psiClass.isAnnotationType() && AnnotationTargetUtil.findAnnotationTarget((PsiClass)psiClass, (PsiAnnotation.TargetType[])targets) != null;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "createSuitabilityCondition"));
            }
            return condition;
        }
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "createSuitabilityCondition"));
        }
        return condition;
    }

    @NotNull
    public MyResult weigh(@NotNull LookupElement item) {
        PsiClass containingClass;
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
        }
        Object object = item.getObject();
        if (object instanceof PsiKeyword) {
            ThreeState result2 = this.isProbableKeyword(((PsiKeyword)object).getText());
            if (result2 == ThreeState.YES) {
                MyResult myResult = MyResult.probableKeyword;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (result2 == ThreeState.NO) {
                MyResult myResult = MyResult.improbableKeyword;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
        }
        if (item.as(CastingLookupElementDecorator.CLASS_CONDITION_KEY) != null) {
            MyResult myResult = MyResult.castVariable;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (object instanceof PsiLocalVariable || object instanceof PsiParameter || object instanceof PsiThisExpression) {
            MyResult myResult = MyResult.localOrParameter;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (object instanceof String && item.getUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS) == Boolean.TRUE) {
            MyResult myResult = MyResult.superMethodParameters;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (object instanceof PsiMethod && (containingClass = ((PsiMethod)object).getContainingClass()) != null && "java.util.Collections".equals(containingClass.getQualifiedName())) {
            MyResult myResult = MyResult.collectionFactory;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (object instanceof PsiClass && "java.lang.String".equals(((PsiClass)object).getQualifiedName()) && JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)this.myPosition)) {
            MyResult myResult = MyResult.unlikelyClass;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        Boolean expectedTypeMember = (Boolean)item.getUserData(MembersGetter.EXPECTED_TYPE_MEMBER);
        if (expectedTypeMember != null) {
            MyResult myResult = expectedTypeMember.booleanValue() ? (object instanceof PsiField ? MyResult.expectedTypeConstant : MyResult.expectedTypeMethod) : MyResult.classNameOrGlobalStatic;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (item instanceof TypeArgumentCompletionProvider.TypeArgsLookupElement) {
            MyResult myResult = MyResult.expectedTypeArgument;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        JavaChainLookupElement chain = (JavaChainLookupElement)item.as(JavaChainLookupElement.CLASS_CONDITION_KEY);
        if (chain != null) {
            Object qualifier = chain.getQualifier().getObject();
            if (qualifier instanceof PsiLocalVariable || qualifier instanceof PsiParameter) {
                MyResult myResult = MyResult.localOrParameter;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (qualifier instanceof PsiField) {
                MyResult myResult = MyResult.qualifiedWithField;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (PreferByKindWeigher.isGetter(qualifier)) {
                MyResult myResult = MyResult.qualifiedWithGetter;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
        }
        if (this.myCompletionType == CompletionType.SMART) {
            if (object instanceof PsiField) {
                MyResult myResult = MyResult.field;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (PreferByKindWeigher.isGetter(object)) {
                MyResult myResult = MyResult.getter;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            MyResult myResult = MyResult.normal;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
            }
            return myResult;
        }
        if (this.myCompletionType == CompletionType.BASIC) {
            StaticallyImportable callElement = (StaticallyImportable)item.as(StaticallyImportable.CLASS_CONDITION_KEY);
            if (callElement != null && callElement.canBeImported() && !callElement.willBeImported()) {
                MyResult myResult = MyResult.classNameOrGlobalStatic;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (object instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)((PsiElement)object))) {
                MyResult myResult = MyResult.annoMethod;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (object instanceof PsiClass) {
                if (this.myRequiredSuper.value((Object)((PsiClass)object))) {
                    MyResult myResult = MyResult.suitableClass;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                    }
                    return myResult;
                }
                MyResult myResult = MyResult.classNameOrGlobalStatic;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
            if (object instanceof PsiField && this.myNonInitializedFields.contains(object)) {
                MyResult myResult = MyResult.nonInitialized;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
                }
                return myResult;
            }
        }
        MyResult myResult = MyResult.normal;
        if (myResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "weigh"));
        }
        return myResult;
    }

    @NotNull
    private ThreeState isProbableKeyword(String keyword) {
        PsiStatement parentStatement;
        if ("return".equals(keyword) && PreferByKindWeigher.isLastStatement(parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiStatement.class)) && !PreferByKindWeigher.isOnTopLevelInVoidMethod(parentStatement)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
            }
            return threeState;
        }
        if (("break".equals(keyword) || "continue".equals(keyword)) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiLoopStatement.class) != null && PreferByKindWeigher.isLastStatement((PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiStatement.class))) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
            }
            return threeState;
        }
        if ("else".equals(keyword) || "finally".equals(keyword) || "catch".equals(keyword)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
            }
            return threeState;
        }
        if ("true".equals(keyword) || "false".equals(keyword)) {
            if (this.myCompletionType == CompletionType.SMART) {
                boolean inReturn = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiReturnStatement.class})).accepts((Object)this.myPosition);
                ThreeState threeState = inReturn ? ThreeState.YES : ThreeState.UNSURE;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
                }
                return threeState;
            }
            if (Arrays.stream(this.myExpectedTypes).anyMatch(info -> PsiType.BOOLEAN.isConvertibleFrom(info.getDefaultType())) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class, PsiMember.class}) == null) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
                }
                return threeState;
            }
        }
        if ("interface".equals(keyword) && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@"})).accepts((Object)this.myPosition)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
            }
            return threeState;
        }
        if ("null".equals(keyword) && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE})))).accepts((Object)this.myPosition)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
            }
            return threeState;
        }
        if (JavaKeywordCompletion.PRIMITIVE_TYPES.contains(keyword) || "void".equals(keyword)) {
            boolean inCallArg = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiExpressionList.class})).accepts((Object)this.myPosition);
            ThreeState threeState = inCallArg || PreferByKindWeigher.isInMethodTypeArg(this.myPosition) ? ThreeState.NO : ThreeState.UNSURE;
            if (threeState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/PreferByKindWeigher", "isProbableKeyword"));
        }
        return threeState;
    }

    static boolean isInMethodTypeArg(PsiElement position) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position);
    }

    private static boolean isOnTopLevelInVoidMethod(PsiStatement statement2) {
        if (!(statement2.getParent() instanceof PsiCodeBlock)) {
            return false;
        }
        PsiElement parent = statement2.getParent().getParent();
        if (parent instanceof PsiMethod) {
            return ((PsiMethod)parent).isConstructor() || PsiType.VOID.equals((Object)((PsiMethod)parent).getReturnType());
        }
        if (parent instanceof PsiLambdaExpression) {
            PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
            return method2 != null && PsiType.VOID.equals((Object)method2.getReturnType());
        }
        return false;
    }

    private static boolean isGetter(Object object) {
        if (!(object instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)object;
        if (!PropertyUtil.hasGetterName((PsiMethod)method2)) {
            return false;
        }
        return !KnownElementWeigher.isGetClass(method2);
    }

    private static boolean isLastStatement(PsiStatement statement2) {
        if (statement2 == null || !(statement2.getParent() instanceof PsiCodeBlock)) {
            return true;
        }
        PsiStatement[] siblings = ((PsiCodeBlock)statement2.getParent()).getStatements();
        PsiStatement lastOne = siblings[siblings.length - 1];
        if (statement2 == lastOne) {
            return true;
        }
        if (siblings.length >= 2 && statement2 == siblings[siblings.length - 2] && lastOne instanceof PsiExpressionStatement) {
            int start = statement2.getTextRange().getStartOffset();
            int end = lastOne.getTextRange().getStartOffset();
            return !StringUtil.contains((CharSequence)statement2.getContainingFile().getViewProvider().getContents(), (int)start, (int)end, (char)'\n');
        }
        return false;
    }

    static enum MyResult {
        annoMethod,
        probableKeyword,
        castVariable,
        localOrParameter,
        qualifiedWithField,
        qualifiedWithGetter,
        superMethodParameters,
        field,
        expectedTypeConstant,
        expectedTypeArgument,
        getter,
        normal,
        collectionFactory,
        expectedTypeMethod,
        suitableClass,
        nonInitialized,
        classNameOrGlobalStatic,
        unlikelyClass,
        improbableKeyword;

    }
}

