/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeInsertHandler
implements InsertHandler<LookupElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.XmlAttributeInsertHandler");
    public static final XmlAttributeInsertHandler INSTANCE = new XmlAttributeInsertHandler();
    private final String myNamespaceToInsert;

    public XmlAttributeInsertHandler() {
        this(null);
    }

    public XmlAttributeInsertHandler(@Nullable String namespaceToInsert) {
        this.myNamespaceToInsert = namespaceToInsert;
    }

    public void handleInsert(InsertionContext context, LookupElement item) {
        boolean hasQuotes;
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        PsiFile file2 = context.getFile();
        CharSequence chars = document.getCharsSequence();
        String quote = XmlAttributeInsertHandler.getAttributeQuote(HtmlUtil.hasHtml(file2) || HtmlUtil.supportsXmlTypedHandlers(file2));
        boolean insertQuotes = WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && StringUtil.isNotEmpty((String)quote);
        boolean bl = hasQuotes = CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"=\"") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"='");
        if (!hasQuotes) {
            PsiElement fileContext = file2.getContext();
            String toInsert = null;
            if (fileContext != null) {
                if (fileContext.getText().startsWith("\"")) {
                    toInsert = "=''";
                }
                if (fileContext.getText().startsWith("'")) {
                    toInsert = "=\"\"";
                }
            }
            if (toInsert == null) {
                toInsert = "=" + quote + quote;
            }
            if (!insertQuotes) {
                toInsert = "=";
            }
            if (caretOffset >= document.getTextLength() || "/> \n\t\r".indexOf(document.getCharsSequence().charAt(caretOffset)) < 0) {
                document.insertString(caretOffset, (CharSequence)(toInsert + " "));
            } else {
                document.insertString(caretOffset, (CharSequence)toInsert);
            }
            if ('=' == context.getCompletionChar()) {
                context.setAddCompletionChar(false);
            }
        }
        editor.getCaretModel().moveToOffset(caretOffset + (insertQuotes || hasQuotes ? 2 : 1));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        AutoPopupController.getInstance(editor.getProject()).scheduleAutoPopup(editor);
        if (this.myNamespaceToInsert != null && file2 instanceof XmlFile) {
            String prefix;
            XmlTag tag;
            PsiElement element = file2.findElementAt(context.getStartOffset());
            XmlTag xmlTag = tag = element != null ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class) : null;
            if (tag != null && (prefix = ExtendedTagInsertHandler.suggestPrefix((XmlFile)file2, this.myNamespaceToInsert)) != null) {
                prefix = XmlAttributeInsertHandler.makePrefixUnique(prefix, tag);
                XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper(context.getFile());
                if (helper != null) {
                    Project project2 = context.getProject();
                    PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
                    XmlAttributeInsertHandler.qualifyWithPrefix(prefix, element);
                    helper.insertNamespaceDeclaration((XmlFile)file2, editor, Collections.singleton(this.myNamespaceToInsert), prefix, null);
                }
            }
        }
    }

    public static String getAttributeQuote(boolean html) {
        return html ? CodeStyleSchemes.getInstance().getCurrentScheme().getCodeStyleSettings().HTML_QUOTE_STYLE.quote : "\"";
    }

    private static void qualifyWithPrefix(@NotNull String namespacePrefix, @NotNull PsiElement context) {
        XmlAttribute attribute;
        String prefix;
        if (namespacePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespacePrefix", "com/intellij/codeInsight/completion/XmlAttributeInsertHandler", "qualifyWithPrefix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/XmlAttributeInsertHandler", "qualifyWithPrefix"));
        }
        PsiElement parent = context.getParent();
        if (parent instanceof XmlAttribute && !(prefix = (attribute = (XmlAttribute)parent).getNamespacePrefix()).equals(namespacePrefix) && StringUtil.isNotEmpty((String)namespacePrefix)) {
            String name = namespacePrefix + ":" + attribute.getLocalName();
            try {
                attribute.setName(name);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    private static String makePrefixUnique(@NotNull String basePrefix, @NotNull XmlTag context) {
        if (basePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePrefix", "com/intellij/codeInsight/completion/XmlAttributeInsertHandler", "makePrefixUnique"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/XmlAttributeInsertHandler", "makePrefixUnique"));
        }
        if (context.getNamespaceByPrefix(basePrefix).isEmpty()) {
            String string = basePrefix;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/XmlAttributeInsertHandler", "makePrefixUnique"));
            }
            return string;
        }
        int i2 = 1;
        while (!context.getNamespaceByPrefix(basePrefix + i2).isEmpty()) {
            ++i2;
        }
        String string = basePrefix + i2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/XmlAttributeInsertHandler", "makePrefixUnique"));
        }
        return string;
    }
}

