/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.actions;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCodeCompletionAction
extends DumbAwareAction
implements HintManagerImpl.ActionToIgnore {
    protected BaseCodeCompletionAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    protected void invokeCompletion(AnActionEvent e, CompletionType type, int time) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        assert (project2 != null);
        assert (editor != null);
        InputEvent inputEvent = e.getInputEvent();
        this.createHandler(type, true, false, true).invokeCompletion(project2, editor, time, inputEvent != null && inputEvent.getModifiers() != 0, false);
    }

    @NotNull
    public CodeCompletionHandlerBase createHandler(@NotNull CompletionType completionType, boolean invokedExplicitly, boolean autopopup, boolean synchronous) {
        if (completionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completionType", "com/intellij/codeInsight/completion/actions/BaseCodeCompletionAction", "createHandler"));
        }
        CodeCompletionHandlerBase codeCompletionHandlerBase = new CodeCompletionHandlerBase(completionType, invokedExplicitly, autopopup, synchronous);
        if (codeCompletionHandlerBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/actions/BaseCodeCompletionAction", "createHandler"));
        }
        return codeCompletionHandlerBase;
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        e.getPresentation().setEnabled(false);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
        if (psiFile == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor.getContentComponent().isShowing()) {
            return;
        }
        e.getPresentation().setEnabled(true);
    }
}

