/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.controlflow.impl;

import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class InstructionImpl
implements Instruction {
    final List<Instruction> myPred = new SmartList();
    final List<Instruction> mySucc = new SmartList();
    protected final PsiElement myElement;
    private final int myNumber;

    @Nullable
    public final PsiElement getElement() {
        return this.myElement;
    }

    public InstructionImpl(ControlFlowBuilder builder, PsiElement element) {
        this.myElement = element;
        this.myNumber = builder.instructionCount++;
    }

    public final Collection<Instruction> allSucc() {
        return this.mySucc;
    }

    public final Collection<Instruction> allPred() {
        return this.myPred;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myNumber);
        builder.append("(");
        for (int i2 = 0; i2 < this.mySucc.size(); ++i2) {
            if (i2 > 0) {
                builder.append(',');
            }
            builder.append(this.mySucc.get(i2).num());
        }
        builder.append(") ").append(this.getElementPresentation());
        return builder.toString();
    }

    public String getElementPresentation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("element: ").append(this.myElement);
        return buffer.toString();
    }

    public final int num() {
        return this.myNumber;
    }
}

