/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChameleonSyntaxHighlightingPass
extends GeneralHighlightingPass {
    ChameleonSyntaxHighlightingPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Document document, @NotNull ProperTextRange restrictRange, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "<init>"));
        }
        super(project2, file2, document, restrictRange.getStartOffset(), restrictRange.getEndOffset(), true, priorityRange, editor, highlightInfoProcessor);
    }

    @Override
    public void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "collectInformationWithProgress"));
        }
        SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)this.myFile).filter(o -> {
            IElementType type = PsiUtilCore.getElementType((PsiElement)o);
            return type instanceof ILazyParseableElementType && !(type instanceof IFileElementType);
        });
        ArrayList lazyOutside = ContainerUtil.newArrayListWithCapacity((int)100);
        ArrayList lazyInside = ContainerUtil.newArrayListWithCapacity((int)100);
        ArrayList outside = ContainerUtil.newArrayListWithCapacity((int)100);
        ArrayList inside = ContainerUtil.newArrayListWithCapacity((int)100);
        for (PsiElement e : s) {
            (e.getTextRange().intersects((TextRange)this.myPriorityRange) ? lazyInside : lazyOutside).add(e);
        }
        for (PsiElement e : lazyInside) {
            this.collectHighlights(e, inside, outside, this.myPriorityRange);
        }
        this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, inside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        for (PsiElement e : lazyOutside) {
            this.collectHighlights(e, inside, outside, this.myPriorityRange);
        }
        this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, outside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
        this.myHighlights.addAll(inside);
        this.myHighlights.addAll(outside);
    }

    private void collectHighlights(@NotNull PsiElement element, @NotNull List<HighlightInfo> inside, @NotNull List<HighlightInfo> outside, @NotNull ProperTextRange priorityRange) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "collectHighlights"));
        }
        if (inside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inside", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "collectHighlights"));
        }
        if (outside == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outside", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "collectHighlights"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass", "collectHighlights"));
        }
        EditorColorsScheme scheme2 = (EditorColorsScheme)ObjectUtils.notNull((Object)this.getColorsScheme(), (Object)EditorColorsManager.getInstance().getGlobalScheme());
        TextAttributes defaultAttrs = scheme2.getAttributes(HighlighterColors.TEXT);
        Language language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)element.getNode());
        if (language == null) {
            return;
        }
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)this.myProject, (VirtualFile)this.myFile.getVirtualFile());
        for (PsiElement token : SyntaxTraverser.psiTraverser((PsiElement)element).traverse(TreeTraversal.LEAVES_DFS)) {
            TextAttributes forcedAttributes;
            TextRange tr = token.getTextRange();
            if (tr.isEmpty()) continue;
            IElementType type = PsiUtilCore.getElementType((PsiElement)token);
            TextAttributesKey[] keys = syntaxHighlighter.getTokenHighlights(type);
            TextAttributes attributes = null;
            for (TextAttributesKey key2 : keys) {
                TextAttributes attrs2 = scheme2.getAttributes(key2);
                if (attrs2 == null) continue;
                attributes = attributes == null ? attrs2 : TextAttributes.merge((TextAttributes)attributes, (TextAttributes)attrs2);
            }
            if (attributes == null || attributes.isEmpty() || attributes.equals((Object)defaultAttrs)) {
                forcedAttributes = TextAttributes.ERASE_MARKER;
            } else {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
                (priorityRange.contains(tr) ? inside : outside).add(info);
                forcedAttributes = new TextAttributes(attributes.getForegroundColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(tr).textAttributes(forcedAttributes).createUnconditionally();
            (priorityRange.contains(tr) ? inside : outside).add(info);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    public static class Factory
    extends AbstractProjectComponent
    implements MainHighlightingPassFactory {
        protected Factory(Project project2, TextEditorHighlightingPassRegistrar registrar) {
            super(project2);
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, false, -1);
        }

        @Override
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory", "createHighlightingPass"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory", "createHighlightingPass"));
            }
            TextRange restrict = FileStatusMap.getDirtyTextRange(editor, 4);
            if (restrict == null) {
                return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument());
            }
            ProperTextRange priority = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
            return new ChameleonSyntaxHighlightingPass(this.myProject, file2, editor.getDocument(), ProperTextRange.create((Segment)restrict), priority, editor, new DefaultHighlightInfoProcessor());
        }

        @Override
        @Nullable
        public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory", "createMainHighlightingPass"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory", "createMainHighlightingPass"));
            }
            if (highlightInfoProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/ChameleonSyntaxHighlightingPass$Factory", "createMainHighlightingPass"));
            }
            ProperTextRange range = ProperTextRange.from((int)0, (int)document.getTextLength());
            return new ChameleonSyntaxHighlightingPass(this.myProject, file2, document, range, range, null, highlightInfoProcessor);
        }
    }
}

