/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfoComposite
extends HighlightInfo {
    @NonNls
    private static final String LINE_BREAK = "<hr size=1 noshade>";

    public HighlightInfoComposite(@NotNull List<HighlightInfo> infos) {
        ArrayList<Object> EMPTY;
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/HighlightInfoComposite", "<init>"));
        }
        super(null, null, infos.get((int)0).type, infos.get((int)0).startOffset, infos.get((int)0).endOffset, HighlightInfoComposite.createCompositeDescription(infos), HighlightInfoComposite.createCompositeTooltip(infos), infos.get((int)0).type.getSeverity(null), false, null, false, 0, infos.get(0).getProblemGroup(), infos.get(0).getGutterIconRenderer());
        this.setHighlighter(infos.get(0).getHighlighter());
        this.setGroup(infos.get(0).getGroup());
        ArrayList<Object> markers = EMPTY = ContainerUtil.emptyList();
        ArrayList<Object> ranges = EMPTY;
        for (HighlightInfo info : infos) {
            if (info.quickFixActionMarkers != null) {
                if (markers == EMPTY) {
                    markers = new ArrayList<Object>();
                }
                markers.addAll(info.quickFixActionMarkers);
            }
            if (info.quickFixActionRanges == null) continue;
            if (ranges == EMPTY) {
                ranges = new ArrayList();
            }
            ranges.addAll(info.quickFixActionRanges);
        }
        this.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList((Collection)markers);
        this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList((Collection)ranges);
    }

    @Nullable
    private static String createCompositeDescription(List<HighlightInfo> infos) {
        StringBuilder description = new StringBuilder();
        boolean isNull = true;
        for (HighlightInfo info : infos) {
            String itemDescription = info.getDescription();
            if (itemDescription == null) continue;
            itemDescription = itemDescription.trim();
            description.append(itemDescription);
            if (!itemDescription.endsWith(".")) {
                description.append('.');
            }
            description.append(' ');
            isNull = false;
        }
        return isNull ? null : description.toString();
    }

    @Nullable
    private static String createCompositeTooltip(@NotNull List<HighlightInfo> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/HighlightInfoComposite", "createCompositeTooltip"));
        }
        StringBuilder result2 = new StringBuilder();
        for (HighlightInfo info : infos) {
            String toolTip = info.getToolTip();
            if (toolTip == null) continue;
            if (result2.length() != 0) {
                result2.append(LINE_BREAK);
            }
            toolTip = XmlStringUtil.stripHtml((String)toolTip);
            result2.append(toolTip);
        }
        if (result2.length() == 0) {
            return null;
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result2);
    }
}

