/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightingSessionImpl
implements HighlightingSession {
    @NotNull
    private final PsiFile myPsiFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final ProgressIndicator myProgressIndicator;
    private final EditorColorsScheme myEditorColorsScheme;
    @NotNull
    private final Project myProject;
    private final Document myDocument;
    private final Map<TextRange, RangeMarker> myRanges2markersCache;
    private final TransferToEDTQueue<Runnable> myEDTQueue;
    private static final Key<ConcurrentMap<PsiFile, HighlightingSession>> HIGHLIGHTING_SESSION = Key.create((String)"HIGHLIGHTING_SESSION");

    private HighlightingSessionImpl(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull DaemonProgressIndicator progressIndicator, EditorColorsScheme editorColorsScheme) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "<init>"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "<init>"));
        }
        this.myRanges2markersCache = new THashMap();
        this.myPsiFile = psiFile;
        this.myEditor = editor;
        this.myProgressIndicator = progressIndicator;
        this.myEditorColorsScheme = editorColorsScheme;
        this.myProject = psiFile.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
        this.myEDTQueue = new TransferToEDTQueue("Apply highlighting results", runnable2 -> {
            runnable2.run();
            return true;
        }, o -> this.myProject.isDisposed() || this.getProgressIndicator().isCanceled(), 200);
    }

    void applyInEDT(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "applyInEDT"));
        }
        this.myEDTQueue.offer((Object)runnable2);
    }

    public static HighlightingSession getHighlightingSession(@NotNull PsiFile psiFile, @NotNull ProgressIndicator progressIndicator) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getHighlightingSession"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getHighlightingSession"));
        }
        Map map = (Map)((DaemonProgressIndicator)progressIndicator).getUserData(HIGHLIGHTING_SESSION);
        return map == null ? null : (HighlightingSession)map.get(psiFile);
    }

    @NotNull
    static HighlightingSession getOrCreateHighlightingSession(@NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull DaemonProgressIndicator progressIndicator, @Nullable EditorColorsScheme editorColorsScheme) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getOrCreateHighlightingSession"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getOrCreateHighlightingSession"));
        }
        HighlightingSession session2 = HighlightingSessionImpl.getHighlightingSession(psiFile, progressIndicator);
        if (session2 == null) {
            ConcurrentMap map = (ConcurrentMap)progressIndicator.getUserData(HIGHLIGHTING_SESSION);
            if (map == null) {
                map = (ConcurrentMap)progressIndicator.putUserDataIfAbsent(HIGHLIGHTING_SESSION, ContainerUtil.newConcurrentMap());
            }
            session2 = (HighlightingSession)ConcurrencyUtil.cacheOrGet((ConcurrentMap)map, (Object)psiFile, (Object)new HighlightingSessionImpl(psiFile, editor, progressIndicator, editorColorsScheme));
        }
        HighlightingSession highlightingSession = session2;
        if (highlightingSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getOrCreateHighlightingSession"));
        }
        return highlightingSession;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getPsiFile"));
        }
        return psiFile;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getDocument"));
        }
        return document;
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getProgressIndicator"));
        }
        return progressIndicator;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "getProject"));
        }
        return project2;
    }

    @Override
    public EditorColorsScheme getColorsScheme() {
        return this.myEditorColorsScheme;
    }

    void queueHighlightInfo(@NotNull HighlightInfo info, @NotNull TextRange restrictedRange, int groupId) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "queueHighlightInfo"));
        }
        if (restrictedRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictedRange", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "queueHighlightInfo"));
        }
        this.myEDTQueue.offer(() -> {
            if (restrictedRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictedRange", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "lambda$queueHighlightInfo$2"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "lambda$queueHighlightInfo$2"));
            }
            EditorColorsScheme colorsScheme = this.getColorsScheme();
            UpdateHighlightersUtil.addHighlighterToEditorIncrementally(this.myProject, this.getDocument(), this.getPsiFile(), restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), info, colorsScheme, groupId, this.myRanges2markersCache);
        });
    }

    void queueDisposeHighlighterFor(@NotNull HighlightInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "queueDisposeHighlighterFor"));
        }
        RangeHighlighterEx highlighter = info.getHighlighter();
        if (highlighter == null) {
            return;
        }
        this.myEDTQueue.offer(() -> {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/HighlightingSessionImpl", "lambda$queueDisposeHighlighterFor$3"));
            }
            Object actualInfo = highlighter.getErrorStripeTooltip();
            if (actualInfo == info && info.getHighlighter() == highlighter) {
                highlighter.dispose();
            }
        });
    }

    void waitForHighlightInfosApplied() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEDTQueue.drain();
    }
}

