/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBatchSuppressByNoInspectionCommentFix
implements ContainerBasedSuppressQuickFix,
InjectionAwareSuppressQuickFix,
Iconable {
    @NotNull
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;
    private ThreeState myShouldBeAppliedToInjectionHost;
    private String myText;

    @Nullable
    public abstract PsiElement getContainer(PsiElement var1);

    public AbstractBatchSuppressByNoInspectionCommentFix(@NotNull String ID2, boolean replaceOtherSuppressionIds) {
        if (ID2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ID", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "<init>"));
        }
        this.myShouldBeAppliedToInjectionHost = ThreeState.UNSURE;
        this.myText = "";
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    public void setShouldBeAppliedToInjectionHost(@NotNull ThreeState shouldBeAppliedToInjectionHost) {
        if (shouldBeAppliedToInjectionHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeAppliedToInjectionHost", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "setShouldBeAppliedToInjectionHost"));
        }
        this.myShouldBeAppliedToInjectionHost = shouldBeAppliedToInjectionHost;
    }

    @NotNull
    public ThreeState isShouldBeAppliedToInjectionHost() {
        ThreeState threeState = this.myShouldBeAppliedToInjectionHost;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "isShouldBeAppliedToInjectionHost"));
        }
        return threeState;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getName"));
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return AllIcons.General.InspectionsOff;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getText"));
        }
        return string;
    }

    protected void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "setText"));
        }
        this.myText = text;
    }

    public String toString() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "applyFix"));
        }
        PsiElement element = descriptor.getStartElement();
        if (element == null) {
            return;
        }
        this.invoke(project2, element);
    }

    public boolean isSuppressAll() {
        return "ALL".equals(this.myID);
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "replaceSuppressionComment"));
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{comment})) {
            return;
        }
        WriteAction.run(() -> {
            if (comment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "lambda$replaceSuppressionComment$0"));
            }
            SuppressionUtil.replaceSuppressionComment(comment, this.myID, this.myReplaceOtherSuppressionIds, this.getCommentLanguage(comment));
        });
    }

    protected void createSuppression(@NotNull Project project2, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "createSuppression"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "createSuppression"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "createSuppression"));
        }
        SuppressionUtil.createSuppression(project2, container, this.myID, this.getCommentLanguage(element));
    }

    @NotNull
    protected Language getCommentLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getCommentLanguage"));
        }
        Language language = element.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getCommentLanguage"));
        }
        return language;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "isAvailable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "isAvailable"));
        }
        return context.isValid() && this.getContainer(context) != null;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "invoke"));
        }
        if (!this.isAvailable(project2, element)) {
            return;
        }
        PsiElement container = this.getContainer(element);
        if (container == null) {
            return;
        }
        if (this.replaceSuppressionComments(container)) {
            return;
        }
        this.createSuppression(project2, element, container);
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    protected boolean replaceSuppressionComments(PsiElement container) {
        List<? extends PsiElement> comments = this.getCommentsFor(container);
        if (comments != null) {
            for (PsiElement psiElement : comments) {
                if (!(psiElement instanceof PsiComment) || !SuppressionUtil.isSuppressionComment(psiElement)) continue;
                this.replaceSuppressionComment(psiElement);
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getCommentsFor"));
        }
        PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)container, (Class[])new Class[]{PsiWhiteSpace.class});
        if (prev == null) {
            return null;
        }
        return Collections.singletonList(prev);
    }

    @NotNull
    public String getFamilyName() {
        String text = this.getText();
        String string = StringUtil.isEmpty((String)text) ? InspectionsBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]) : text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/actions/AbstractBatchSuppressByNoInspectionCommentFix", "getFamilyName"));
        }
        return string;
    }
}

