/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaHighlightingUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + LambdaHighlightingUtil.class.getName()));

    @Nullable
    public static String checkInterfaceFunctional(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/daemon/impl/analysis/LambdaHighlightingUtil", "checkInterfaceFunctional"));
        }
        return LambdaHighlightingUtil.checkInterfaceFunctional(psiClass, "Target type of a lambda conversion must be an interface");
    }

    @Nullable
    static String checkInterfaceFunctional(@NotNull PsiClass psiClass, String interfaceNonFunctionalMessage) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/daemon/impl/analysis/LambdaHighlightingUtil", "checkInterfaceFunctional"));
        }
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        List signatures = LambdaUtil.findFunctionCandidates((PsiClass)psiClass);
        if (signatures == null) {
            return interfaceNonFunctionalMessage;
        }
        if (signatures.isEmpty()) {
            return "No target method found";
        }
        if (signatures.size() == 1) {
            return null;
        }
        return "Multiple non-overriding abstract methods found in interface " + HighlightUtil.formatClass(psiClass);
    }

    @Nullable
    static HighlightInfo checkParametersCompatible(PsiLambdaExpression expression, PsiParameter[] methodParameters, PsiSubstitutor substitutor) {
        PsiParameter[] lambdaParameters = expression.getParameterList().getParameters();
        String incompatibleTypesMessage = "Incompatible parameter types in lambda expression: ";
        if (lambdaParameters.length != methodParameters.length) {
            incompatibleTypesMessage = incompatibleTypesMessage + "wrong number of parameters: expected " + methodParameters.length + " but found " + lambdaParameters.length;
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression.getParameterList()).descriptionAndTooltip(incompatibleTypesMessage).create();
        }
        boolean hasFormalParameterTypes = expression.hasFormalParameterTypes();
        for (int i2 = 0; i2 < lambdaParameters.length; ++i2) {
            PsiParameter lambdaParameter = lambdaParameters[i2];
            PsiType lambdaParameterType = lambdaParameter.getType();
            PsiType substitutedParamType = substitutor.substitute(methodParameters[i2].getType());
            if ((!hasFormalParameterTypes || PsiTypesUtil.compareTypes((PsiType)lambdaParameterType, (PsiType)substitutedParamType, (boolean)true)) && TypeConversionUtil.isAssignable((PsiType)substitutedParamType, (PsiType)lambdaParameterType)) continue;
            String expectedType = substitutedParamType != null ? substitutedParamType.getPresentableText() : null;
            String actualType = lambdaParameterType.getPresentableText();
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression.getParameterList()).descriptionAndTooltip(incompatibleTypesMessage + "expected " + expectedType + " but found " + actualType).create();
        }
        return null;
    }

    public static boolean insertSemicolonAfter(PsiLambdaExpression lambdaExpression) {
        return lambdaExpression.getBody() instanceof PsiCodeBlock || !LambdaHighlightingUtil.insertSemicolon(lambdaExpression.getParent());
    }

    public static boolean insertSemicolon(PsiElement parent) {
        return parent instanceof PsiExpressionList || parent instanceof PsiExpression;
    }

    @Nullable
    public static String checkInterfaceFunctional(PsiType functionalInterfaceType) {
        if (functionalInterfaceType instanceof PsiIntersectionType) {
            HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
            for (PsiType type : ((PsiIntersectionType)functionalInterfaceType).getConjuncts()) {
                if (LambdaHighlightingUtil.checkInterfaceFunctional(type) != null) continue;
                MethodSignature signature = LambdaUtil.getFunction((PsiClass)PsiUtil.resolveClassInType((PsiType)type));
                LOG.assertTrue(signature != null, (Object)type.getCanonicalText());
                signatures.add(signature);
            }
            if (signatures.size() > 1) {
                return "Multiple non-overriding abstract methods found in " + functionalInterfaceType.getPresentableText();
            }
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiClass aClass = resolveResult.getElement();
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return null;
            }
            MethodSignature functionalMethod = LambdaUtil.getFunction((PsiClass)aClass);
            if (functionalMethod != null && functionalMethod.getTypeParameters().length > 0) {
                return "Target method is generic";
            }
            if (LambdaHighlightingUtil.checkReturnTypeApplicable(resolveResult, aClass)) {
                return "No instance of type " + functionalInterfaceType.getPresentableText() + " exists so that lambda expression can be type-checked";
            }
            return LambdaHighlightingUtil.checkInterfaceFunctional(aClass);
        }
        return functionalInterfaceType.getPresentableText() + " is not a functional interface";
    }

    private static boolean checkReturnTypeApplicable(PsiClassType.ClassResolveResult resolveResult, PsiClass aClass) {
        MethodSignature methodSignature = LambdaUtil.getFunction((PsiClass)aClass);
        if (methodSignature == null) {
            return false;
        }
        for (PsiTypeParameter parameter : aClass.getTypeParameters()) {
            PsiType substitution;
            if (parameter.getExtendsListTypes().length == 0 || !((substitution = resolveResult.getSubstitutor().substitute(parameter)) instanceof PsiWildcardType) || ((PsiWildcardType)substitution).isBounded()) continue;
            boolean depends = false;
            for (PsiType paramType : methodSignature.getParameterTypes()) {
                if (!LambdaUtil.depends((PsiType)paramType, (LambdaUtil.TypeParamsChecker)new LambdaUtil.TypeParamsChecker((PsiElement)((PsiMethod)null), aClass){

                    public boolean startedInference() {
                        return true;
                    }
                }, (PsiTypeParameter[])new PsiTypeParameter[]{parameter})) continue;
                depends = true;
                break;
            }
            if (depends) continue;
            return true;
        }
        return false;
    }
}

