/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlHighlightVisitorBasedInspection
extends GlobalSimpleInspectionTool {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public void checkFile(final @NotNull PsiFile file2, final @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "checkFile"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "checkFile"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "checkFile"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptionsProcessor", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "checkFile"));
        }
        HighlightInfoHolder myHolder = new HighlightInfoHolder(file2, new HighlightInfoFilter[0]){

            @Override
            public boolean add(@Nullable HighlightInfo info) {
                if (info != null) {
                    GlobalInspectionUtil.createProblem((PsiElement)file2, info, new TextRange(info.startOffset, info.endOffset), null, manager, problemDescriptionsProcessor, globalContext);
                }
                return true;
            }
        };
        final XmlHighlightVisitor highlightVisitor = new XmlHighlightVisitor();
        highlightVisitor.analyze(file2, true, myHolder, new Runnable(){

            @Override
            public void run() {
                file2.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitElement(PsiElement element) {
                        highlightVisitor.visit(element);
                        super.visitElement(element);
                    }
                });
            }
        });
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionProfileEntry.GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("XML highlighting" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "getDisplayName"));
        }
        return "XML highlighting";
    }

    @NotNull
    public String getShortName() {
        if ("XmlHighlighting" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/XmlHighlightVisitorBasedInspection", "getShortName"));
        }
        return "XmlHighlighting";
    }
}

