/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddReturnFix
implements IntentionAction {
    private final PsiMethod myMethod;

    public AddReturnFix(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "<init>"));
        }
        this.myMethod = method2;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.return.statement.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "isAvailable"));
        }
        return this.myMethod.isValid() && this.myMethod.getManager().isInProject((PsiElement)this.myMethod) && this.myMethod.getBody() != null && this.myMethod.getBody().getRBrace() != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "getElementToMakeWritable"));
        }
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "getElementToMakeWritable"));
        }
        return psiMethod;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "invoke"));
        }
        String value = this.suggestReturnValue();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
        PsiReturnStatement returnStatement = (PsiReturnStatement)factory.createStatementFromText("return " + value + ";", (PsiElement)this.myMethod);
        PsiCodeBlock body = this.myMethod.getBody();
        returnStatement = (PsiReturnStatement)body.addBefore((PsiElement)returnStatement, (PsiElement)body.getRBrace());
        MethodReturnTypeFix.selectReturnValueInEditor(returnStatement, editor);
    }

    private String suggestReturnValue() {
        String conversion;
        PsiVariable[] variables;
        PsiType type = this.myMethod.getReturnType();
        for (PsiVariable variable : variables = AddReturnFix.getDeclaredVariables(this.myMethod)) {
            PsiType varType = variable.getType();
            if (!varType.equals(type)) continue;
            return variable.getName();
        }
        for (PsiVariable variable : variables) {
            conversion = this.getConversionToType(variable, type, true);
            if (conversion == null) continue;
            return conversion;
        }
        for (PsiVariable variable : variables) {
            conversion = this.getConversionToType(variable, type, false);
            if (conversion == null) continue;
            return conversion;
        }
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type);
    }

    private String getConversionToType(@NotNull PsiVariable variable, @Nullable PsiType type, boolean preciseTypeReqired) {
        PsiType arrayComponentType;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/AddReturnFix", "getConversionToType"));
        }
        PsiType varType = variable.getType();
        if (type instanceof PsiArrayType && !((arrayComponentType = ((PsiArrayType)type).getComponentType()) instanceof PsiPrimitiveType) && !(PsiUtil.resolveClassInType((PsiType)arrayComponentType) instanceof PsiTypeParameter) && InheritanceUtil.isInheritor((PsiType)varType, (String)"java.util.Collection")) {
            PsiType collectionItemType;
            PsiType erasedComponentType = TypeConversionUtil.erasure((PsiType)arrayComponentType);
            if ((!preciseTypeReqired || arrayComponentType.equals(erasedComponentType)) && (collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)varType, (GlobalSearchScope)this.myMethod.getResolveScope())) != null && erasedComponentType.isAssignableFrom(collectionItemType)) {
                if (erasedComponentType.equalsToText("java.lang.Object")) {
                    return variable.getName() + ".toArray()";
                }
                return variable.getName() + ".toArray(new " + erasedComponentType.getCanonicalText() + "[0])";
            }
        }
        return null;
    }

    private static PsiVariable[] getDeclaredVariables(PsiMethod method2) {
        PsiStatement[] statements;
        ArrayList<PsiVariable> variables = new ArrayList<PsiVariable>();
        for (PsiStatement statement2 : statements = method2.getBody().getStatements()) {
            PsiElement[] declaredElements;
            if (!(statement2 instanceof PsiDeclarationStatement)) continue;
            for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)statement2).getDeclaredElements()) {
                if (!(declaredElement instanceof PsiLocalVariable)) continue;
                variables.add((PsiVariable)declaredElement);
            }
        }
        Object[] parameters = method2.getParameterList().getParameters();
        ContainerUtil.addAll(variables, (Object[])parameters);
        return variables.toArray(new PsiVariable[variables.size()]);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

