/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeClassSignature.TypeParameterInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ChangeClassSignatureFromUsageFix
extends BaseIntentionAction {
    private final PsiClass myClass;
    private final PsiReferenceParameterList myParameterList;

    public ChangeClassSignatureFromUsageFix(@NotNull PsiClass aClass, @NotNull PsiReferenceParameterList parameterList) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "<init>"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "<init>"));
        }
        this.myClass = aClass;
        this.myParameterList = parameterList;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.class.signature.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "isAvailable"));
        }
        if (!this.myClass.isValid() || !this.myParameterList.isValid()) {
            return false;
        }
        if (this.myClass.getTypeParameters().length >= this.myParameterList.getTypeArguments().length) {
            return false;
        }
        PsiTypeParameterList classTypeParameterList = this.myClass.getTypeParameterList();
        if (classTypeParameterList == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("change.class.signature.text", this.myClass.getName(), this.myParameterList.getText()));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "invoke"));
        }
        PsiTypeParameterList classTypeParameterList = this.myClass.getTypeParameterList();
        if (classTypeParameterList == null) {
            return;
        }
        ChangeClassSignatureDialog dialog2 = new ChangeClassSignatureDialog(this.myClass, ChangeClassSignatureFromUsageFix.createTypeParameters(JavaCodeFragmentFactory.getInstance((Project)project2), Arrays.asList(classTypeParameterList.getTypeParameters()), Arrays.asList(this.myParameterList.getTypeParameterElements())), false);
        dialog2.show();
    }

    @NotNull
    private static List<TypeParameterInfoView> createTypeParameters(@NotNull JavaCodeFragmentFactory factory, @NotNull List<PsiTypeParameter> classTypeParameters, @NotNull List<PsiTypeElement> typeElements) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "createTypeParameters"));
        }
        if (classTypeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classTypeParameters", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "createTypeParameters"));
        }
        if (typeElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElements", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "createTypeParameters"));
        }
        TypeParameterNameSuggester suggester = new TypeParameterNameSuggester(classTypeParameters);
        ArrayList<TypeParameterInfoView> result2 = new ArrayList<TypeParameterInfoView>();
        int listIndex = 0;
        for (PsiTypeElement typeElement : typeElements) {
            String suggestedName;
            PsiTypeParameter typeParameter;
            if (listIndex < classTypeParameters.size() && ChangeClassSignatureFromUsageFix.isAssignable(typeParameter = classTypeParameters.get(listIndex), typeElement.getType())) {
                result2.add(new TypeParameterInfoView(new TypeParameterInfo.Existing(listIndex++), null, null));
                continue;
            }
            PsiType defaultType = typeElement.getType();
            PsiClassType boundType = null;
            if (defaultType instanceof PsiClassType) {
                PsiClassType[] types;
                PsiReferenceList extendsList;
                suggestedName = suggester.suggest((PsiClassType)defaultType);
                PsiClass resolved = ((PsiClassType)defaultType).resolve();
                if (resolved != null && (extendsList = resolved.getExtendsList()) != null && (types = extendsList.getReferencedTypes()).length == 1) {
                    boundType = types[0];
                }
            } else {
                suggestedName = suggester.suggestUnusedName("T");
            }
            PsiTypeCodeFragment boundFragment = ChangeClassSignatureDialog.createTableCodeFragment(boundType, (PsiElement)typeElement, factory, true);
            result2.add(new TypeParameterInfoView(new TypeParameterInfo.New(suggestedName, defaultType, null), boundFragment, boundType == null ? factory.createTypeCodeFragment(suggestedName, (PsiElement)typeElement, true) : ChangeClassSignatureDialog.createTableCodeFragment(boundType, (PsiElement)typeElement, factory, false)));
        }
        ArrayList<TypeParameterInfoView> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "createTypeParameters"));
        }
        return arrayList;
    }

    private static boolean isAssignable(@NotNull PsiTypeParameter typeParameter, @NotNull PsiType type) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "isAssignable"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix", "isAssignable"));
        }
        for (PsiClassType t : typeParameter.getExtendsListTypes()) {
            if (t.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static class TypeParameterInfoView {
        private final TypeParameterInfo myInfo;
        private final PsiTypeCodeFragment myBoundValueFragment;
        private final PsiTypeCodeFragment myDefaultValueFragment;

        public TypeParameterInfoView(TypeParameterInfo info, PsiTypeCodeFragment boundValueFragment, PsiTypeCodeFragment defaultValueFragment) {
            this.myInfo = info;
            this.myBoundValueFragment = boundValueFragment;
            this.myDefaultValueFragment = defaultValueFragment;
        }

        public TypeParameterInfo getInfo() {
            return this.myInfo;
        }

        public PsiTypeCodeFragment getBoundValueFragment() {
            return this.myBoundValueFragment;
        }

        public PsiTypeCodeFragment getDefaultValueFragment() {
            return this.myDefaultValueFragment;
        }
    }

    private static class TypeParameterNameSuggester {
        private final Set<String> usedNames;

        public TypeParameterNameSuggester(PsiTypeParameter ... typeParameters) {
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix$TypeParameterNameSuggester", "<init>"));
            }
            this(Arrays.asList(typeParameters));
        }

        public TypeParameterNameSuggester(@NotNull Collection<PsiTypeParameter> typeParameters) {
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix$TypeParameterNameSuggester", "<init>"));
            }
            this.usedNames = new HashSet<String>();
            for (PsiTypeParameter p : typeParameters) {
                this.usedNames.add(p.getName());
            }
        }

        @NotNull
        private String suggestUnusedName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix$TypeParameterNameSuggester", "suggestUnusedName"));
            }
            String unusedName = name;
            int i2 = 0;
            while (true) {
                if (this.usedNames.add(unusedName)) {
                    String string = unusedName;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix$TypeParameterNameSuggester", "suggestUnusedName"));
                    }
                    return string;
                }
                unusedName = name + ++i2;
            }
        }

        @NotNull
        public String suggest(@NotNull PsiClassType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix$TypeParameterNameSuggester", "suggest"));
            }
            String string = this.suggestUnusedName(type.getClassName().substring(0, 1).toUpperCase());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeClassSignatureFromUsageFix$TypeParameterNameSuggester", "suggest"));
            }
            return string;
        }
    }
}

