/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertCollectionToArrayFix
implements IntentionAction {
    private final PsiExpression myCollectionExpression;
    private final String myNewArrayText;

    public ConvertCollectionToArrayFix(@NotNull PsiExpression collectionExpression, @NotNull PsiArrayType arrayType) {
        if (collectionExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectionExpression", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "<init>"));
        }
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "<init>"));
        }
        this.myCollectionExpression = collectionExpression;
        PsiType componentType = arrayType.getComponentType();
        this.myNewArrayText = componentType.equalsToText("java.lang.Object") ? "" : "new " + ConvertCollectionToArrayFix.getArrayTypeText(componentType);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("collection.to.array.text", this.myNewArrayText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("collection.to.array.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "isAvailable"));
        }
        return this.myCollectionExpression.isValid() && PsiManager.getInstance((Project)project2).isInProject((PsiElement)this.myCollectionExpression);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "invoke"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String replacement = ParenthesesUtils.getText(this.myCollectionExpression, 2) + ".toArray(" + this.myNewArrayText + ")";
        this.myCollectionExpression.replace((PsiElement)factory.createExpressionFromText(replacement, (PsiElement)this.myCollectionExpression));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private static String getArrayTypeText(PsiType componentType) {
        if (componentType instanceof PsiArrayType) {
            String string = ConvertCollectionToArrayFix.getArrayTypeText(((PsiArrayType)componentType).getComponentType()) + "[]";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "getArrayTypeText"));
            }
            return string;
        }
        if (componentType instanceof PsiClassType) {
            String string = ((PsiClassType)componentType).rawType().getCanonicalText() + "[0]";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "getArrayTypeText"));
            }
            return string;
        }
        String string = componentType.getCanonicalText() + "[0]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertCollectionToArrayFix", "getArrayTypeText"));
        }
        return string;
    }
}

