/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import org.jetbrains.annotations.NotNull;

public class InsertSuperFix
implements IntentionAction,
HighPriorityAction {
    private final PsiMethod myConstructor;

    public InsertSuperFix(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix", "<init>"));
        }
        this.myConstructor = constructor;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("insert.super.constructor.call.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("insert.super.constructor.call.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix", "isAvailable"));
        }
        return this.myConstructor.isValid() && this.myConstructor.getBody() != null && this.myConstructor.getBody().getLBrace() != null && this.myConstructor.getManager().isInProject((PsiElement)this.myConstructor);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix", "getElementToMakeWritable"));
        }
        PsiMethod psiMethod = this.myConstructor;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix", "getElementToMakeWritable"));
        }
        return psiMethod;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix", "invoke"));
        }
        PsiStatement superCall = JavaPsiFacade.getInstance((Project)this.myConstructor.getProject()).getElementFactory().createStatementFromText("super();", null);
        PsiCodeBlock body = this.myConstructor.getBody();
        PsiJavaToken lBrace = body.getLBrace();
        body.addAfter((PsiElement)superCall, (PsiElement)lBrace);
        lBrace = (PsiJavaToken)new PsiMatcherImpl((PsiElement)body).firstChild(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiExpressionList.class)).firstChild(PsiMatchers.hasClass(PsiJavaToken.class)).dot(PsiMatchers.hasText("(")).getElement();
        editor.getCaretModel().moveToOffset(lBrace.getTextOffset() + 1);
        UndoUtil.markPsiFileForUndo((PsiFile)file2);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

