/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class MoveCatchUpFix
implements IntentionAction {
    private final PsiCatchSection myCatchSection;
    private final PsiCatchSection myMoveBeforeSection;

    public MoveCatchUpFix(@NotNull PsiCatchSection catchSection, @NotNull PsiCatchSection moveBeforeSection) {
        if (catchSection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "catchSection", "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix", "<init>"));
        }
        if (moveBeforeSection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moveBeforeSection", "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix", "<init>"));
        }
        this.myCatchSection = catchSection;
        this.myMoveBeforeSection = moveBeforeSection;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("move.catch.up.text", JavaHighlightUtil.formatType(this.myCatchSection.getCatchType()), JavaHighlightUtil.formatType(this.myMoveBeforeSection.getCatchType()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("move.catch.up.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix", "isAvailable"));
        }
        return this.myCatchSection.isValid() && this.myCatchSection.getManager().isInProject((PsiElement)this.myCatchSection) && this.myMoveBeforeSection.isValid() && this.myCatchSection.getCatchType() != null && PsiUtil.resolveClassInType((PsiType)this.myCatchSection.getCatchType()) != null && this.myMoveBeforeSection.getCatchType() != null && PsiUtil.resolveClassInType((PsiType)this.myMoveBeforeSection.getCatchType()) != null && !this.myCatchSection.getManager().areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)this.myCatchSection.getCatchType()), (PsiElement)PsiUtil.resolveClassInType((PsiType)this.myMoveBeforeSection.getCatchType()));
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix", "getElementToMakeWritable"));
        }
        PsiCatchSection psiCatchSection = this.myCatchSection;
        if (psiCatchSection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix", "getElementToMakeWritable"));
        }
        return psiCatchSection;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MoveCatchUpFix", "invoke"));
        }
        PsiTryStatement statement2 = this.myCatchSection.getTryStatement();
        statement2.addBefore((PsiElement)this.myCatchSection, (PsiElement)this.myMoveBeforeSection);
        this.myCatchSection.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

