/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveNewQualifierFix
implements IntentionAction {
    private final PsiNewExpression expression;
    private final PsiClass aClass;

    public RemoveNewQualifierFix(@NotNull PsiNewExpression expression, PsiClass aClass) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix", "<init>"));
        }
        this.expression = expression;
        this.aClass = aClass;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.qualifier.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.qualifier.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix", "isAvailable"));
        }
        return this.expression.isValid() && (this.aClass == null || this.aClass.isValid()) && this.expression.getManager().isInProject((PsiElement)this.expression);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix", "getElementToMakeWritable"));
        }
        PsiNewExpression psiNewExpression = this.expression;
        if (psiNewExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix", "getElementToMakeWritable"));
        }
        return psiNewExpression;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveNewQualifierFix", "invoke"));
        }
        PsiJavaCodeReferenceElement classReference = this.expression.getClassReference();
        this.expression.getQualifier().delete();
        if (this.aClass != null && classReference != null) {
            classReference.bindToElement((PsiElement)this.aClass);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

