/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInaccessibleFieldWithGetterSetterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myMethodName;
    private final boolean myIsSetter;

    public ReplaceInaccessibleFieldWithGetterSetterFix(@NotNull PsiElement element, @NotNull PsiMethod getter, boolean isSetter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix", "<init>"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix", "<init>"));
        }
        super(element);
        this.myMethodName = getter.getName();
        this.myIsSetter = isSetter;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix", "invoke"));
        }
        PsiReferenceExpression place = (PsiReferenceExpression)startElement;
        String qualifier = null;
        PsiExpression qualifierExpression = place.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifier = qualifierExpression.getText();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        String call = (qualifier != null ? qualifier + "." : "") + this.myMethodName;
        if (!this.myIsSetter) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(call + "()", null);
            callExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)callExpression);
            place.replace((PsiElement)callExpression);
        } else {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)place, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiAssignmentExpression) {
                PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
                String argList = rExpression != null ? rExpression.getText() : "";
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(call + "(" + argList + ")", null);
                callExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)callExpression);
                parent.replace((PsiElement)callExpression);
            }
        }
    }

    @NotNull
    public String getText() {
        String string = this.myIsSetter ? "Replace with setter" : "Replace with getter";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Replace with getter/setter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceInaccessibleFieldWithGetterSetterFix", "getFamilyName"));
        }
        return "Replace with getter/setter";
    }
}

