/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.editorActions.emacs.EmacsProcessingHandler;
import com.intellij.codeInsight.editorActions.emacs.LanguageEmacsExtension;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class EmacsStyleIndentAction
extends BaseCodeInsightAction
implements DumbAware {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        Handler handler2 = new Handler();
        if (handler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction", "getHandler"));
        }
        return handler2;
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction", "isValidForFile"));
        }
        PsiElement context = file2.findElementAt(editor.getCaretModel().getOffset());
        return context != null && LanguageFormatting.INSTANCE.forContext(context) != null;
    }

    private static class Handler
    implements CodeInsightActionHandler {
        private Handler() {
        }

        public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
            EmacsProcessingHandler.Result result2;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler", "invoke"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler", "invoke"));
            }
            EmacsProcessingHandler emacsProcessingHandler = (EmacsProcessingHandler)LanguageEmacsExtension.INSTANCE.forLanguage(file2.getLanguage());
            if (emacsProcessingHandler != null && (result2 = emacsProcessingHandler.changeIndent(project2, editor, file2)) == EmacsProcessingHandler.Result.STOP) {
                return;
            }
            Document document = editor.getDocument();
            int startLine = document.getLineNumber(editor.getSelectionModel().getSelectionStart());
            int endLine = document.getLineNumber(editor.getSelectionModel().getSelectionEnd());
            for (int line = startLine; line <= endLine; ++line) {
                int lineStart = document.getLineStartOffset(line);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
                int newPos = codeStyleManager.adjustLineIndent(file2, lineStart);
                if (startLine != endLine || editor.getCaretModel().getOffset() >= newPos) continue;
                editor.getCaretModel().moveToOffset(newPos);
                editor.getSelectionModel().removeSelection();
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }
    }
}

