/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoverWrapper {
    private static final Logger LOGGER = Logger.getInstance(MoverWrapper.class);
    protected final boolean myIsDown;
    private final StatementUpDownMover myMover;
    private final StatementUpDownMover.MoveInfo myInfo;

    protected MoverWrapper(@NotNull StatementUpDownMover mover, @NotNull StatementUpDownMover.MoveInfo info, boolean isDown) {
        if (mover == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mover", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "<init>"));
        }
        this.myMover = mover;
        this.myIsDown = isDown;
        this.myInfo = info;
    }

    public StatementUpDownMover.MoveInfo getInfo() {
        return this.myInfo;
    }

    public final void move(Editor editor, PsiFile file2) {
        assert (this.myInfo.toMove2 != null);
        this.myMover.beforeMove(editor, this.myInfo, this.myIsDown);
        Document document = editor.getDocument();
        Project project2 = file2.getProject();
        if (!this.myInfo.toMove.equals(this.myInfo.toMove2)) {
            TextRange range2;
            TextRange range;
            int start = StatementUpDownMover.getLineStartSafeOffset((Document)document, (int)this.myInfo.toMove.startLine);
            int end = StatementUpDownMover.getLineStartSafeOffset((Document)document, (int)this.myInfo.toMove.endLine);
            String textToInsert = document.getCharsSequence().subSequence(start, end).toString();
            if (!StringUtil.endsWithChar((CharSequence)textToInsert, (char)'\n')) {
                textToInsert = textToInsert + '\n';
            }
            int start2 = document.getLineStartOffset(this.myInfo.toMove2.startLine);
            int end2 = StatementUpDownMover.getLineStartSafeOffset((Document)document, (int)this.myInfo.toMove2.endLine);
            String textToInsert2 = document.getCharsSequence().subSequence(start2, end2).toString();
            if (!StringUtil.endsWithChar((CharSequence)textToInsert2, (char)'\n')) {
                textToInsert2 = textToInsert2 + '\n';
            }
            if ((range = new TextRange(start, end)).intersectsStrict(range2 = new TextRange(start2, end2)) && !range.equals((Object)range2)) {
                LOGGER.error("Wrong move ranges requested by " + this.myMover, new Attachment[]{new Attachment("ranges.txt", start + ":" + end + "(" + textToInsert + ")\n" + start2 + ":" + end2 + "(" + textToInsert2 + ")")});
                return;
            }
            this.myInfo.range1 = document.createRangeMarker(start, end);
            this.myInfo.range2 = document.createRangeMarker(start2, end2);
            if (this.myInfo.range1.getStartOffset() < this.myInfo.range2.getStartOffset()) {
                this.myInfo.range1.setGreedyToLeft(true);
                this.myInfo.range1.setGreedyToRight(false);
                this.myInfo.range2.setGreedyToLeft(true);
                this.myInfo.range2.setGreedyToRight(true);
            } else {
                this.myInfo.range1.setGreedyToLeft(true);
                this.myInfo.range1.setGreedyToRight(true);
                this.myInfo.range2.setGreedyToLeft(true);
                this.myInfo.range2.setGreedyToRight(false);
            }
            CaretModel caretModel = editor.getCaretModel();
            int caretRelativePos = caretModel.getOffset() - start;
            SelectionModel selectionModel = editor.getSelectionModel();
            int selectionStart = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            boolean hasSelection = selectionModel.hasSelection();
            caretModel.moveToOffset(0);
            FoldRegion topRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range1);
            FoldRegion bottomRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range2);
            if (document instanceof DocumentEx) {
                int startFirst = Math.min(start, start2);
                int endFirst = Math.min(end, end2);
                int startSecond = Math.max(start, start2);
                int endSecond = Math.max(end, end2);
                ((DocumentEx)document).moveText(startFirst, endFirst, startSecond);
                ((DocumentEx)document).moveText(startSecond, endSecond, startFirst);
                this.myInfo.range1.dispose();
                this.myInfo.range2.dispose();
                this.myInfo.range1 = document.createRangeMarker(start < start2 ? start : start2 + end - end2, start < start2 ? start + end2 - start2 : end);
                this.myInfo.range2 = document.createRangeMarker(start < start2 ? start + end2 - end : start2, start < start2 ? end2 : start2 + end - start);
                MoverWrapper.insertLineBreakInTheEndIfMissing(this.myInfo.range1);
                MoverWrapper.insertLineBreakInTheEndIfMissing(this.myInfo.range2);
            } else {
                document.insertString(this.myInfo.range1.getStartOffset(), (CharSequence)textToInsert2);
                document.deleteString(this.myInfo.range1.getStartOffset() + textToInsert2.length(), this.myInfo.range1.getEndOffset());
                document.insertString(this.myInfo.range2.getStartOffset(), (CharSequence)textToInsert);
                int s = this.myInfo.range2.getStartOffset() + textToInsert.length();
                int e = this.myInfo.range2.getEndOffset();
                if (e > s) {
                    document.deleteString(s, e);
                }
            }
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            if (topRegion != null && bottomRegion != null) {
                CodeFoldingManager.getInstance(project2).updateFoldRegions(editor);
                editor.getFoldingModel().runBatchFoldingOperation(() -> {
                    FoldRegion newBottomRegion;
                    FoldRegion newTopRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range1);
                    if (newTopRegion != null) {
                        newTopRegion.setExpanded(bottomRegion.isExpanded());
                    }
                    if ((newBottomRegion = MoverWrapper.findTopLevelRegionInRange(editor, this.myInfo.range2)) != null) {
                        newBottomRegion.setExpanded(topRegion.isExpanded());
                    }
                });
            }
            if (hasSelection) {
                MoverWrapper.restoreSelection(editor, selectionStart, selectionEnd, start, end, this.myInfo.range2.getStartOffset());
            }
            caretModel.moveToOffset(this.myInfo.range2.getStartOffset() + caretRelativePos);
        }
        this.myMover.afterMove(editor, file2, this.myInfo, this.myIsDown);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        if (this.myInfo.indentTarget) {
            MoverWrapper.indentLinesIn(editor, file2, document, project2, this.myInfo.range2);
        }
        if (this.myInfo.indentSource) {
            MoverWrapper.indentLinesIn(editor, file2, document, project2, this.myInfo.range1);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private static void insertLineBreakInTheEndIfMissing(@NotNull RangeMarker marker) {
        int endOffset;
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "insertLineBreakInTheEndIfMissing"));
        }
        Document document = marker.getDocument();
        int startOffset = marker.getStartOffset();
        if (startOffset == (endOffset = marker.getEndOffset()) || document.getImmutableCharSequence().charAt(endOffset - 1) != '\n') {
            marker.setGreedyToRight(true);
            document.insertString(endOffset, (CharSequence)"\n");
        }
    }

    private static FoldRegion findTopLevelRegionInRange(Editor editor, RangeMarker range) {
        FoldRegion result2 = null;
        for (FoldRegion foldRegion : editor.getFoldingModel().getAllFoldRegions()) {
            if (!foldRegion.isValid() || !MoverWrapper.contains(range, foldRegion) || MoverWrapper.contains(result2, foldRegion)) continue;
            result2 = foldRegion;
        }
        return result2;
    }

    private static boolean contains(@NotNull RangeMarker rangeMarker, @NotNull FoldRegion foldRegion) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "contains"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldRegion", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "contains"));
        }
        return rangeMarker.getStartOffset() <= foldRegion.getStartOffset() && rangeMarker.getEndOffset() >= foldRegion.getEndOffset();
    }

    private static boolean contains(@Nullable FoldRegion region1, @NotNull FoldRegion region2) {
        if (region2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region2", "com/intellij/codeInsight/editorActions/moveUpDown/MoverWrapper", "contains"));
        }
        if (region1 == null) {
            return false;
        }
        return region1.getStartOffset() <= region2.getStartOffset() && region1.getEndOffset() >= region2.getEndOffset();
    }

    private static void indentLinesIn(Editor editor, PsiFile file2, Document document, Project project2, RangeMarker range) {
        int line1;
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        int line2 = editor.offsetToLogicalPosition((int)range.getEndOffset()).line;
        for (line1 = editor.offsetToLogicalPosition((int)range.getStartOffset()).line; !MoverWrapper.lineContainsNonSpaces(document, line1) && line1 < line2; ++line1) {
        }
        while (!MoverWrapper.lineContainsNonSpaces(document, line2) && line1 < line2) {
            --line2;
        }
        FileViewProvider provider = file2.getViewProvider();
        PsiFile rootToAdjustIndentIn = provider.getPsi(provider.getBaseLanguage());
        codeStyleManager.adjustLineIndent(rootToAdjustIndentIn, new TextRange(document.getLineStartOffset(line1), document.getLineStartOffset(line2)));
    }

    private static boolean lineContainsNonSpaces(Document document, int line) {
        if (line >= document.getLineCount()) {
            return false;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        int lineEndOffset = document.getLineEndOffset(line);
        String text = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset).toString();
        return text.trim().length() != 0;
    }

    private static void restoreSelection(Editor editor, int selectionStart, int selectionEnd, int moveStartOffset, int moveEndOffset, int insOffset) {
        int selectionRelativeStartOffset = Math.max(0, selectionStart - moveStartOffset);
        int selectionRelativeEndOffset = Math.min(moveEndOffset - moveStartOffset, selectionEnd - moveStartOffset);
        int newSelectionStart = insOffset + selectionRelativeStartOffset;
        int newSelectionEnd = insOffset + selectionRelativeEndOffset;
        EditorUtil.setSelectionExpandingFoldedRegionsIfNeeded(editor, newSelectionStart, newSelectionEnd);
    }
}

