/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpandRegionAction
extends EditorAction {
    public ExpandRegionAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
                ExpandRegionAction.expandRegionAtCaret(editor.getProject(), editor);
            }
        });
    }

    private static void expandRegionAtCaret(Project project2, @Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        ExpandRegionAction.expandRegionAtOffset(project2, editor, editor.getCaretModel().getOffset());
    }

    public static void expandRegionAtOffset(@NotNull Project project2, @NotNull Editor editor, int offset) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/folding/impl/actions/ExpandRegionAction", "expandRegionAtOffset"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/actions/ExpandRegionAction", "expandRegionAtOffset"));
        }
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project2);
        foldingManager.updateFoldRegions(editor);
        int line = editor.getDocument().getLineNumber(offset);
        Runnable processor2 = () -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/actions/ExpandRegionAction", "lambda$expandRegionAtOffset$0"));
            }
            FoldRegion region = FoldingUtil.findFoldRegionStartingAtLine(editor, line);
            if (region != null && !region.isExpanded()) {
                region.setExpanded(true);
            } else {
                FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset);
                for (int i = regions.length - 1; i >= 0; --i) {
                    region = regions[i];
                    if (region.isExpanded()) continue;
                    region.setExpanded(true);
                    break;
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor2);
    }
}

